/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.execution.debugger.memory.GotoAddressPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryViewPanel
implements ComponentContainer {
    @NotNull
    protected final JPanel myComponent = new JPanel(new BorderLayout());
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final FileEditor myFileEditor;
    @NotNull
    protected final GotoAddressPanel myGotoAddressPanel;

    private MemoryViewPanel(@NotNull Project project, @NotNull FileEditor fileEditor, @NotNull GotoAddressPanel gotoAddressPanel) {
        this.myProject = project;
        this.myFileEditor = fileEditor;
        this.myGotoAddressPanel = gotoAddressPanel;
        this.myComponent.add((Component)((Object)this.myGotoAddressPanel), "First");
        this.myComponent.add(fileEditor.getComponent());
    }

    @Nullable
    public static MemoryViewPanel create(@NotNull Project project, @NotNull VirtualFile file) {
        FileEditorProvider[] providers = FileEditorProviderManager.getInstance().getProviders(project, file);
        if (providers.length == 0) {
            return null;
        }
        FileEditorProvider provider = providers[0];
        FileEditor fileEditor = provider.createEditor(project, file);
        GotoAddressPanel gotoAddressPanel = (GotoAddressPanel)((Object)GotoAddressPanel.GOTO_ADDRESS_FILE_EDITOR_KEY.get((UserDataHolder)fileEditor));
        if (gotoAddressPanel == null) {
            Disposer.dispose((Disposable)fileEditor);
            return null;
        }
        MemoryViewPanel memoryViewPanel = new MemoryViewPanel(project, fileEditor, gotoAddressPanel);
        Disposer.register((Disposable)memoryViewPanel, (Disposable)fileEditor);
        return memoryViewPanel;
    }

    public void dispose() {
    }

    @NotNull
    public JComponent getComponent() {
        return this.myComponent;
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myGotoAddressPanel.getPreferredFocusedComponent();
    }

    @NotNull
    public FileEditor getFileEditor() {
        return this.myFileEditor;
    }

    @NotNull
    public GotoAddressPanel getGotoAddressPanel() {
        return this.myGotoAddressPanel;
    }
}

