/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerSourceFileHash;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrSuspensionCause {
    @NotNull
    @NlsSafe
    public final String type;
    @NotNull
    @NlsSafe
    public final String reason;
    @Nullable
    public final String file;
    @Nullable
    public final DebuggerSourceFileHash hash;
    public final int line;
    @NotNull
    public final Address address;
    @NotNull
    public final Icon icon = AllIcons.Debugger.Db_exception_breakpoint;

    public CidrSuspensionCause(@NotNull String type, @NotNull String reason, @Nullable String file, @Nullable DebuggerSourceFileHash hash, int line, @NotNull Address address) {
        this.type = type;
        this.reason = reason;
        this.file = file;
        this.hash = hash;
        this.line = line;
        this.address = address;
    }

    @NotNull
    @NlsContexts.Tooltip
    public String getDisplayString() {
        return this.type + ": " + this.reason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CidrSuspensionCause cause = (CidrSuspensionCause)o;
        if (!this.reason.equals(cause.reason)) {
            return false;
        }
        return this.type.equals(cause.type);
    }

    public int hashCode() {
        int result2 = this.type.hashCode();
        result2 = 31 * result2 + this.reason.hashCode();
        return result2;
    }
}

