/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColoredText;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.TextTransferable;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLanguageSupportManager;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrFrameTypeDecorator;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrStackFrame
extends XStackFrame
implements UserDataHolderEx {
    @NotNull
    private final UserDataHolderBase myUserDataHolder = new UserDataHolderBase();
    @NotNull
    private final CidrDebugProcess myProcess;
    @NotNull
    private final LLThread myThread;
    @NotNull
    private final LLFrame myFrame;
    @Nullable
    private final CidrSuspensionCause mySuspensionCause;
    @Nullable
    private final XSourcePosition mySourcePosition;
    private final boolean myHasSourceFile;
    public static final Key<Boolean> THROW_ON_VARIABLES_COLLECTION = Key.create((String)"THROW_ON_VARIABLES_COLLECTION");

    public CidrStackFrame(@NotNull CidrDebugProcess process, @NotNull LLThread thread, @NotNull LLFrame frame, @Nullable CidrSuspensionCause suspensionCause) {
        this.myProcess = process;
        this.myThread = thread;
        this.myFrame = frame;
        this.mySuspensionCause = suspensionCause;
        Pair<XSourcePosition, Boolean> position = this.myProcess.createSourceOrDisasmPosition(this.myFrame.getFile(), this.myFrame.getHash(), this.myFrame.getLine(), this.myFrame.getProgramCounter());
        this.mySourcePosition = (XSourcePosition)position.first;
        this.myHasSourceFile = (Boolean)position.second;
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        this.myUserDataHolder.putUserData(key, value);
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        return (T)this.myUserDataHolder.putUserDataIfAbsent(key, value);
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        return this.myUserDataHolder.replace(key, oldValue, newValue);
    }

    @NotNull
    public CidrDebugProcess getProcess() {
        return this.myProcess;
    }

    @NotNull
    public LLThread getThread() {
        return this.myThread;
    }

    public long getThreadId() {
        return this.myThread.getId();
    }

    @NotNull
    public LLFrame getFrame() {
        return this.myFrame;
    }

    public int getFrameIndex() {
        return this.myFrame.getIndex();
    }

    public Object getEqualityObject() {
        return Pair.create((Object)this.myThread.getId(), (Object)this.myFrame.getIndex());
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.mySourcePosition;
    }

    @Nullable
    public XSourcePosition getSourcePosition(boolean allowDisassembly) {
        return allowDisassembly || this.myHasSourceFile ? this.mySourcePosition : null;
    }

    public boolean hasSourceFile() {
        return this.myHasSourceFile;
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        boolean showModule;
        String module;
        SimpleTextAttributes unknownSymbolAttributes;
        XSourcePosition position = this.getSourcePosition(false);
        SimpleTextAttributes functionNameAttributes = position != null ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
        SimpleTextAttributes simpleTextAttributes = unknownSymbolAttributes = position != null ? SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES : SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES;
        if (this.myFrame.getInlined()) {
            component.append(CidrDebuggerBundle.message("stack.frame.label.inlined", new Object[0]) + " ", SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
        }
        String string = module = (showModule = CidrDebuggerSettings.getInstance().isShowFrameModuleName()) ? this.myFrame.getModule() : null;
        if (module != null) {
            component.append("[" + module + "] ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
        if (this.myFrame.hasSymbolInfo()) {
            if (!Registry.is((String)"cidr.debugger.frameTypeDecorator", (boolean)true)) {
                component.append(this.myFrame.getFunction(), functionNameAttributes);
            } else {
                CidrFrameTypeDecorator decorator = this.getFrameTypeDecorator();
                boolean isPlainTextRendering = component instanceof TextTransferable.ColoredStringBuilder;
                ColoredText coloredText = decorator.getFrameFunctionColoredText(this, functionNameAttributes, !isPlainTextRendering);
                component.append(coloredText);
            }
        } else {
            component.append(CidrDebuggerBundle.message("debug.frames.unknownFunction", new Object[0]), unknownSymbolAttributes);
        }
        if (position != null) {
            component.append(" " + position.getFile().getName() + ":" + (position.getLine() + 1), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        } else {
            component.append(" " + this.myFrame.getProgramCounter(), SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
        }
    }

    public final void computeChildren(@NotNull XCompositeNode node) {
        if (CidrDebugProcess.viewsUpdatesDisabledInTests(node)) {
            return;
        }
        this.myProcess.postCommand(driver -> {
            try {
                this.doComputeChildren(driver, node);
            }
            catch (DebuggerCommandException e) {
                node.setErrorMessage(e.getMessage());
            }
            catch (ExecutionException e) {
                node.setErrorMessage(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                throw e;
            }
        });
    }

    private void doComputeChildren(@NotNull DebuggerDriver driver, @NotNull XCompositeNode node) throws DebuggerCommandException, ExecutionException {
        if (node.isObsolete()) {
            return;
        }
        if (this.mySuspensionCause != null) {
            XValueChildrenList list = new XValueChildrenList(1);
            list.add(new XNamedValue(this.mySuspensionCause.type){

                public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
                    node.setPresentation(CidrStackFrame.this.mySuspensionCause.icon, null, CidrStackFrame.this.mySuspensionCause.reason, false);
                }
            });
            node.addChildren(list, false);
        }
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_VARIABLES_COLLECTION);
        XSourcePosition framePosition = this.getSourcePosition(false);
        driver.setValuesFilteringEnabled(CidrDebuggerSettings.getInstance().isValuesFilterEnabled());
        List<LLValue> vars = this.myFrame.getLanguage() == DebuggerDriver.StandardDebuggerLanguage.SWIFT ? ((LLDBDriver)driver).getVariables(this.myThread.getId(), this.myFrame.getIndex(), true, true) : driver.getVariables(this.myThread, this.myFrame);
        this.myProcess.getTypesHelper(this).filterLocalVariables(framePosition, vars, () -> ((XCompositeNode)node).isObsolete()).whenComplete((filteredVars, t) -> {
            if (filteredVars != null) {
                CidrValue.addLocalValues(filteredVars, this.myProcess, framePosition, this, node);
            } else {
                vars.forEach(v -> v.setValid(false));
                CidrValue.addLocalValues(vars, this.myProcess, framePosition, this, node);
            }
        });
    }

    public CidrEvaluator getEvaluator() {
        return CidrDebuggerLanguageSupportManager.getInstance().createEvaluator(this);
    }

    @NotNull
    public CidrFrameTypeDecorator getFrameTypeDecorator() {
        return CidrDebuggerLanguageSupportManager.getInstance().createFrameTypeDecorator(this);
    }

    public String toString() {
        return this.myFrame.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CidrStackFrame frame = (CidrStackFrame)((Object)o);
        return this.myProcess.equals(frame.myProcess) && this.myThread.equals(frame.myThread) && this.myFrame.equals(frame.myFrame);
    }

    public int hashCode() {
        return Objects.hash(this.myProcess, this.myThread, this.myFrame);
    }
}

