/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.attach.XLocalAttachDebugger;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrLocalAttachedDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrLocalAttachDebugger
implements XLocalAttachDebugger {
    @NotNull
    private final DebuggerDriverConfiguration myConfiguration;

    public CidrLocalAttachDebugger(@NotNull DebuggerDriverConfiguration configuration) {
        this.myConfiguration = configuration;
    }

    @NotNull
    public String getDebuggerDisplayName() {
        return this.myConfiguration.getDriverName();
    }

    @NotNull
    public DebuggerDriverConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    public void attachDebugSession(@NotNull Project project, @NotNull ProcessInfo processInfo) throws ExecutionException {
        this.doAttachDebugSession(project, processInfo, AllIcons.Actions.StartDebugger, new XDebugSessionListener[0]);
    }

    @NotNull
    public XDebugSession doAttachDebugSession(@NotNull Project project, final @NotNull ProcessInfo processInfo, @Nullable Icon icon, final XDebugSessionListener ... listeners) throws ExecutionException {
        return XDebuggerManager.getInstance((Project)project).startSessionAndShowTab(processInfo.getExecutableDisplayName(), icon, null, false, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) throws ExecutionException {
                for (XDebugSessionListener l : listeners) {
                    session.addSessionListener(l);
                }
                CidrDebugProcess process = CidrLocalAttachDebugger.this.doCreateDebugProcess(session, processInfo);
                process.start();
                return process;
            }
        });
    }

    @NotNull
    protected CidrDebugProcess doCreateDebugProcess(@NotNull XDebugSession session, final @NotNull ProcessInfo processInfo) throws ExecutionException {
        TextConsoleBuilder consoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(session.getProject());
        return new CidrLocalAttachedDebugProcess(this.myConfiguration, processInfo, session, consoleBuilder){

            @Override
            protected void restartDebugger(@NotNull XDebugSession session) {
                Project project = this.getProject();
                try {
                    CidrLocalAttachDebugger.this.doAttachDebugSession(project, processInfo, session.getRunContentDescriptor().getIcon(), new XDebugSessionListener[0]);
                }
                catch (ExecutionException e) {
                    String message = XDebuggerBundle.message((String)"xdebugger.attach.pid", (Object[])new Object[]{processInfo.getPid()});
                    ExecutionUtil.handleExecutionError((Project)project, (String)"Debug", (String)message, (Throwable)e);
                }
            }
        };
    }
}

