/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.util.EventDispatcher;
import com.intellij.util.PlatformUtils;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.settings.DebuggerSettingsCategory;
import com.intellij.xdebugger.settings.XDebuggerSettings;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettingsConfigurable;
import com.jetbrains.cidr.execution.debugger.NtSymbolSettings;
import com.jetbrains.cidr.execution.debugger.backend.lldb.formatters.LLDBNatvisDiagnosticsLevel;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;

public class CidrDebuggerSettings
extends XDebuggerSettings<CidrDebuggerSettings> {
    private boolean myRenderersEnabled = true;
    private final EventDispatcher<SettingListener> myRenderersEnabledDispatcher = EventDispatcher.create(SettingListener.class);
    private boolean myValuesFilterEnabled = true;
    private final EventDispatcher<SettingListener> myValuesFilterEnabledDispatcher = EventDispatcher.create(SettingListener.class);
    private boolean myCocoaRenderersEnabled = true;
    private boolean myCoreDataRenderersEnabled = true;
    private final EventDispatcher<SettingListener> myCocoaRenderersEnabledDispatcher = EventDispatcher.create(SettingListener.class);
    private boolean myStlRenderersEnabled = true;
    private final EventDispatcher<SettingListener> myStlRenderersEnabledDispatcher = EventDispatcher.create(SettingListener.class);
    private boolean myHexFormattingEnabled = false;
    private boolean myHexAsSecondaryFormattingEnabled = true;
    private final EventDispatcher<SettingListener> myHexFormattingSettingsDispatcher = EventDispatcher.create(SettingListener.class);
    private boolean myMuteVariables = false;
    private final EventDispatcher<SettingListener> myMuteVariablesDispatcher = EventDispatcher.create(SettingListener.class);
    private boolean myLLDBNatvisRenderersEnabled = true;
    private LLDBNatvisDiagnosticsLevel myLLDBNatvisDiagnosticsLevel = LLDBNatvisDiagnosticsLevel.DISABLED;
    private final EventDispatcher<SettingListener> myNatvisSettingsDispatcher = EventDispatcher.create(SettingListener.class);
    private boolean myShowFrameModuleName = false;
    private boolean myShowFrameFunctionParameters = true;
    private boolean myShowFrameFunctionTemplateArguments = false;
    private final EventDispatcher<SettingListener> myFrameDecorationSettingsDispatcher = EventDispatcher.create(SettingListener.class);
    private boolean myShowTypes = true;
    private boolean myShowTypeTemplateArguments = true;
    private final EventDispatcher<SettingListener> myValuePresentationSettingsDispatcher = EventDispatcher.create(SettingListener.class);
    private boolean myStripCxxAuxiliaryNamespaces = true;
    private boolean mySugarizeCxxStlTypes = true;
    @NotNull
    private NtSymbolSettings myNtSymbolSettings = new NtSymbolSettings();

    @OptionTag(value="RENDERERS_ENABLED")
    public boolean isRenderersEnabled() {
        return this.myRenderersEnabled;
    }

    public void setRenderersEnabled(boolean renderersEnabled) {
        if (this.myRenderersEnabled != renderersEnabled) {
            this.myRenderersEnabled = renderersEnabled;
            this.fireRenderersEnabledChanged();
        }
    }

    @OptionTag(value="VALUES_FILTER_ENABLED")
    public boolean isValuesFilterEnabled() {
        return this.myValuesFilterEnabled;
    }

    public void setValuesFilterEnabled(boolean valuesFilterEnabled) {
        if (this.myValuesFilterEnabled != valuesFilterEnabled) {
            this.myValuesFilterEnabled = valuesFilterEnabled;
            this.fireValuesFilterEnabledChanged();
        }
    }

    @OptionTag(value="COCOA_RENDERERS_ENABLED")
    public boolean isCocoaRenderersEnabled() {
        return this.myCocoaRenderersEnabled;
    }

    public void setCocoaRenderersEnabled(boolean cocoaRenderersEnabled) {
        if (this.myCocoaRenderersEnabled != cocoaRenderersEnabled) {
            this.myCocoaRenderersEnabled = cocoaRenderersEnabled;
            this.fireCocoaRenderersEnabledChanged();
        }
    }

    @OptionTag(value="CORE_DATA_RENDERERS_ENABLED")
    public boolean isCoreDataRenderersEnabled() {
        return this.myCoreDataRenderersEnabled;
    }

    public void setCoreDataRenderersEnabled(boolean coreDataRenderersEnabled) {
        if (this.myCoreDataRenderersEnabled != coreDataRenderersEnabled) {
            this.myCoreDataRenderersEnabled = coreDataRenderersEnabled;
            this.fireCocoaRenderersEnabledChanged();
        }
    }

    @OptionTag(value="STL_RENDERERS_ENABLED")
    public boolean isStlRenderersEnabled() {
        return this.myStlRenderersEnabled;
    }

    public void setStlRenderersEnabled(boolean stlRenderersEnabled) {
        if (this.myStlRenderersEnabled != stlRenderersEnabled) {
            this.myStlRenderersEnabled = stlRenderersEnabled;
            this.fireStlRenderersEnabledChanged();
        }
    }

    @OptionTag(value="MUTE_VARIABLES")
    public boolean isMuteVariables() {
        return this.myMuteVariables;
    }

    public void setMuteVariables(boolean muteVariables) {
        if (this.myMuteVariables != muteVariables) {
            this.myMuteVariables = muteVariables;
            this.fireMuteVariablesChanged();
        }
    }

    @OptionTag(value="LLDB_NATVIS_RENDERERS_ENABLED")
    public boolean isLLDBNatvisRenderersEnabled() {
        return this.myLLDBNatvisRenderersEnabled;
    }

    public void setLLDBNatvisRenderersEnabled(boolean LLDBNatvisRenderersEnabled) {
        if (this.myLLDBNatvisRenderersEnabled != LLDBNatvisRenderersEnabled) {
            this.myLLDBNatvisRenderersEnabled = LLDBNatvisRenderersEnabled;
            this.fireNatvisSettingsChanged();
        }
    }

    @OptionTag(value="LLDB_NATVIS_DIAGNOSTICS_LEVEL")
    public LLDBNatvisDiagnosticsLevel getLLDBNatvisDiagnosticsLevel() {
        return this.myLLDBNatvisDiagnosticsLevel;
    }

    public void setLLDBNatvisDiagnosticsLevel(LLDBNatvisDiagnosticsLevel LLDBNatvisDiagnosticsLevel2) {
        if (this.myLLDBNatvisDiagnosticsLevel != LLDBNatvisDiagnosticsLevel2) {
            this.myLLDBNatvisDiagnosticsLevel = LLDBNatvisDiagnosticsLevel2;
            this.fireNatvisSettingsChanged();
        }
    }

    @OptionTag(value="HEX_FORMATTING_ENABLED")
    public boolean isHexFormattingEnabled() {
        return this.myHexFormattingEnabled;
    }

    public void setHexFormattingEnabled(boolean value) {
        if (this.myHexFormattingEnabled != value) {
            this.myHexFormattingEnabled = value;
            this.fireHexFormattingSettingsChanged();
        }
    }

    @OptionTag(value="HEX_AS_SECONDARY_FORMATTING_ENABLED")
    public boolean isHexAsSecondaryFormattingEnabled() {
        return this.myHexAsSecondaryFormattingEnabled;
    }

    public void setHexAsSecondaryFormattingEnabled(boolean value) {
        if (this.myHexAsSecondaryFormattingEnabled != value) {
            this.myHexAsSecondaryFormattingEnabled = value;
            this.fireHexFormattingSettingsChanged();
        }
    }

    @OptionTag(value="SHOW_FRAME_MODULE_NAME")
    public boolean isShowFrameModuleName() {
        return this.myShowFrameModuleName;
    }

    public void setShowFrameModuleName(boolean showFrameModuleName) {
        if (this.myShowFrameModuleName != showFrameModuleName) {
            this.myShowFrameModuleName = showFrameModuleName;
            this.fireFrameDecorationSettingsChanged();
        }
    }

    @OptionTag(value="SHOW_FRAME_FUNCTION_PARAMETERS")
    public boolean isShowFrameFunctionParameters() {
        return this.myShowFrameFunctionParameters;
    }

    public void setShowFrameFunctionParameters(boolean showFrameFunctionParameters) {
        if (this.myShowFrameFunctionParameters != showFrameFunctionParameters) {
            this.myShowFrameFunctionParameters = showFrameFunctionParameters;
            this.fireFrameDecorationSettingsChanged();
        }
    }

    @OptionTag(value="SHOW_FRAME_FUNCTION_TEMPLATE_ARGUMENTS")
    public boolean isShowFrameFunctionTemplateArguments() {
        return this.myShowFrameFunctionTemplateArguments;
    }

    public void setShowFrameFunctionTemplateArguments(boolean showFrameFunctionTemplateArguments) {
        if (this.myShowFrameFunctionTemplateArguments != showFrameFunctionTemplateArguments) {
            this.myShowFrameFunctionTemplateArguments = showFrameFunctionTemplateArguments;
            this.fireFrameDecorationSettingsChanged();
        }
    }

    @OptionTag(value="SHOW_TYPES")
    public boolean isShowTypes() {
        return this.myShowTypes;
    }

    public void setShowTypes(boolean showTypes) {
        if (this.myShowTypes != showTypes) {
            this.myShowTypes = showTypes;
            this.fireValuePresentationSettingsChanged();
        }
    }

    @OptionTag(value="SHOW_TYPE_TEMPLATE_ARGUMENTS")
    public boolean isShowTypeTemplateArguments() {
        return this.myShowTypeTemplateArguments;
    }

    public void setShowTypeTemplateArguments(boolean showTypeTemplateArguments) {
        if (this.myShowTypeTemplateArguments != showTypeTemplateArguments) {
            this.myShowTypeTemplateArguments = showTypeTemplateArguments;
            this.fireValuePresentationSettingsChanged();
        }
    }

    @OptionTag(value="STRIP_CXX_AUXILIARY_NAMESPACES")
    public boolean isStripCxxAuxiliaryNamespaces() {
        return this.myStripCxxAuxiliaryNamespaces;
    }

    public void setStripCxxAuxiliaryNamespaces(boolean stripCxxAuxiliaryNamespaces) {
        if (this.myStripCxxAuxiliaryNamespaces != stripCxxAuxiliaryNamespaces) {
            this.myStripCxxAuxiliaryNamespaces = stripCxxAuxiliaryNamespaces;
            this.fireFrameDecorationSettingsChanged();
            this.fireValuePresentationSettingsChanged();
        }
    }

    @OptionTag(value="SUGARIZE_CXX_STL_TYPES")
    public boolean isSugarizeCxxStlTypes() {
        return this.mySugarizeCxxStlTypes;
    }

    public void setSugarizeCxxStlTypes(boolean sugarizeCxxStlTypes) {
        if (this.mySugarizeCxxStlTypes != sugarizeCxxStlTypes) {
            this.mySugarizeCxxStlTypes = sugarizeCxxStlTypes;
            this.fireFrameDecorationSettingsChanged();
            this.fireValuePresentationSettingsChanged();
        }
    }

    @Property(surroundWithTag=false)
    @NotNull
    public NtSymbolSettings getNtSymbolSettings() {
        return this.myNtSymbolSettings;
    }

    public void setNtSymbolSettings(@NotNull NtSymbolSettings symbolSettings) {
        this.myNtSymbolSettings = symbolSettings;
    }

    @NotNull
    public static CidrDebuggerSettings getInstance() {
        return (CidrDebuggerSettings)CidrDebuggerSettings.getInstance(CidrDebuggerSettings.class);
    }

    public CidrDebuggerSettings() {
        super("ObjectiveC");
    }

    public static void updateCurrentDebugSession(AnActionEvent e) {
        XDebugSession session;
        XDebuggerTree tree;
        if (DebuggerUIUtil.isInDetachedTree((AnActionEvent)e) && (tree = XDebuggerTree.getTree((AnActionEvent)e)) != null) {
            tree.rebuildAndRestore(XDebuggerTreeState.saveState((XDebuggerTree)tree));
        }
        if ((session = DebuggerUIUtil.getSession((AnActionEvent)e)) != null) {
            session.rebuildViews();
        }
    }

    @NotNull
    public Collection<? extends Configurable> createConfigurables(@NotNull DebuggerSettingsCategory category) {
        if (category == DebuggerSettingsCategory.DATA_VIEWS) {
            return Collections.singletonList(new CidrDebuggerSettingsConfigurable(this));
        }
        return Collections.emptyList();
    }

    public boolean isTargetedToProduct(@NotNull Configurable configurable) {
        String displayName = configurable.getDisplayName();
        if (PlatformUtils.isAppCode()) {
            return CidrDebuggerBundle.message("debug.settings.name.objective.c", new Object[0]).equals(displayName);
        }
        if (PlatformUtils.isCLion()) {
            return CidrDebuggerBundle.message("debug.settings.name.c.cpp", new Object[0]).equals(displayName);
        }
        return false;
    }

    public CidrDebuggerSettings getState() {
        return this;
    }

    public void loadState(@NotNull CidrDebuggerSettings state) {
        XmlSerializerUtil.copyBean((Object)((Object)state), (Object)((Object)this));
    }

    public void addRenderersEnabledListener(SettingListener listener, Disposable disposable) {
        this.myRenderersEnabledDispatcher.addListener((EventListener)listener, disposable);
    }

    public void addValuesFilterEnabledListener(SettingListener listener, Disposable disposable) {
        this.myValuesFilterEnabledDispatcher.addListener((EventListener)listener, disposable);
    }

    public void addCocoaRenderersEnabledListener(SettingListener listener, Disposable disposable) {
        this.myCocoaRenderersEnabledDispatcher.addListener((EventListener)listener, disposable);
    }

    public void addStlRenderersEnabledListener(SettingListener listener, Disposable disposable) {
        this.myStlRenderersEnabledDispatcher.addListener((EventListener)listener, disposable);
    }

    public void addHexFormattingSettingsListener(SettingListener listener, Disposable disposable) {
        this.myHexFormattingSettingsDispatcher.addListener((EventListener)listener, disposable);
    }

    public void addMuteVariablesListener(SettingListener listener, Disposable disposable) {
        this.myMuteVariablesDispatcher.addListener((EventListener)listener, disposable);
    }

    public void addNatvisSettingsListener(SettingListener listener, Disposable disposable) {
        this.myNatvisSettingsDispatcher.addListener((EventListener)listener, disposable);
    }

    public void addFrameDecorationSettingsListener(SettingListener listener, Disposable disposable) {
        this.myFrameDecorationSettingsDispatcher.addListener((EventListener)listener, disposable);
    }

    public void addValuePresentationSettingsListener(SettingListener listener, Disposable disposable) {
        this.myValuePresentationSettingsDispatcher.addListener((EventListener)listener, disposable);
    }

    public void fireRenderersEnabledChanged() {
        ((SettingListener)this.myRenderersEnabledDispatcher.getMulticaster()).settingChanged();
    }

    public void fireValuesFilterEnabledChanged() {
        ((SettingListener)this.myValuesFilterEnabledDispatcher.getMulticaster()).settingChanged();
    }

    public void fireCocoaRenderersEnabledChanged() {
        ((SettingListener)this.myCocoaRenderersEnabledDispatcher.getMulticaster()).settingChanged();
    }

    public void fireStlRenderersEnabledChanged() {
        ((SettingListener)this.myStlRenderersEnabledDispatcher.getMulticaster()).settingChanged();
    }

    private void fireHexFormattingSettingsChanged() {
        ((SettingListener)this.myHexFormattingSettingsDispatcher.getMulticaster()).settingChanged();
    }

    public void fireMuteVariablesChanged() {
        ((SettingListener)this.myMuteVariablesDispatcher.getMulticaster()).settingChanged();
    }

    public void fireNatvisSettingsChanged() {
        ((SettingListener)this.myNatvisSettingsDispatcher.getMulticaster()).settingChanged();
    }

    public void fireFrameDecorationSettingsChanged() {
        ((SettingListener)this.myFrameDecorationSettingsDispatcher.getMulticaster()).settingChanged();
    }

    public void fireValuePresentationSettingsChanged() {
        ((SettingListener)this.myValuePresentationSettingsDispatcher.getMulticaster()).settingChanged();
    }

    public static interface SettingListener
    extends EventListener {
        public void settingChanged();
    }
}

