/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XNamedTreeNode;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.InlineDebuggerHelper;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerEditorsExtension;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrDebuggerEditorsProvider
extends XDebuggerEditorsProvider {
    public static final ExtensionPointName<LanguageExtensionPoint<CidrDebuggerEditorsExtension>> EP_NAME = ExtensionPointName.create((String)"cidr.debugger.editorsExtension");
    private static final LanguageExtension<CidrDebuggerEditorsExtension> EXTENSION = new LanguageExtension(EP_NAME);

    @NotNull
    private static LanguageExtensionPoint<CidrDebuggerEditorsExtension> getDefaultExtension() {
        return (LanguageExtensionPoint)EP_NAME.extensions().findFirst().orElseThrow(() -> new IllegalStateException("No default extension for " + EP_NAME.getName()));
    }

    @NotNull
    public final FileType getFileType() {
        LanguageFileType fileType = CidrDebuggerEditorsProvider.getDefaultLanguage().getAssociatedFileType();
        return fileType != null ? fileType : FileTypes.UNKNOWN;
    }

    @NotNull
    private static Language getDefaultLanguage() {
        Language language = Language.findLanguageByID((String)CidrDebuggerEditorsProvider.getDefaultExtension().getKey());
        return language != null ? language : Language.ANY;
    }

    @NotNull
    public Collection<Language> getSupportedLanguages(@NotNull Project project, @Nullable XSourcePosition sourcePosition) {
        return Collections.singleton(CidrDebuggerEditorsProvider.getLanguage(null, sourcePosition));
    }

    @NotNull
    public Document createDocument(@NotNull Project project, @NotNull XExpression expression, @Nullable XSourcePosition sourcePosition, @NotNull EvaluationMode mode) {
        String text = expression.getExpression();
        if (sourcePosition != null) {
            Document document2;
            Language language = CidrDebuggerEditorsProvider.getLanguage(expression, sourcePosition);
            CidrDebuggerEditorsExtension extension = (CidrDebuggerEditorsExtension)EXTENSION.forLanguage(language);
            if (extension == null) {
                extension = (CidrDebuggerEditorsExtension)CidrDebuggerEditorsProvider.getDefaultExtension().getInstance();
            }
            if ((document2 = extension.createDocument(project, text, sourcePosition, mode)) != null) {
                return document2;
            }
        }
        LightVirtualFile plainTextFile = new LightVirtualFile("oc-debug-editor-when-no-source-position-available.txt", (FileType)FileTypes.PLAIN_TEXT, (CharSequence)text);
        Document document3 = FileDocumentManager.getInstance().getDocument((VirtualFile)plainTextFile);
        return Objects.requireNonNull(document3, "Unable to create plain text document for expression");
    }

    @NotNull
    private static Language getLanguage(@Nullable XExpression expression, @Nullable XSourcePosition position) {
        FileType type;
        if (expression != null && expression.getLanguage() != null) {
            return expression.getLanguage();
        }
        if (position != null && (type = position.getFile().getFileType()) instanceof LanguageFileType) {
            return ((LanguageFileType)type).getLanguage();
        }
        return CidrDebuggerEditorsProvider.getDefaultLanguage();
    }

    @NotNull
    public InlineDebuggerHelper getInlineDebuggerHelper() {
        return new InlineDebuggerHelper(){

            public boolean shouldEvaluateChildrenByDefault(@NotNull XNamedTreeNode node) {
                return !CidrDebuggerSettings.getInstance().isMuteVariables() && DEFAULT.shouldEvaluateChildrenByDefault(node);
            }
        };
    }
}

