/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import org.jetbrains.annotations.NotNull;

public class CidrDebugConsoleCompletionContributor
extends CompletionContributor
implements DumbAware {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        CidrDebugProcess process;
        PsiFile originalFile;
        Document document2;
        boolean autoPopupCompletions = Registry.is((String)"cidr.debugger.console.completion.autoPopup", (boolean)false);
        if ((autoPopupCompletions || parameters.getInvocationCount() > 0) && (document2 = PsiDocumentManager.getInstance((Project)(originalFile = parameters.getOriginalFile()).getProject()).getDocument(originalFile)) != null && (process = (CidrDebugProcess)document2.getUserData(CidrDebugProcess.DEBUG_PROCESS_KEY)) != null) {
            process.completeConsoleCommand(parameters, result2.withPrefixMatcher(CidrDebugConsoleCompletionContributor.createPrefixMatcher(parameters)));
        }
        super.fillCompletionVariants(parameters, result2);
    }

    @NotNull
    private static PrefixMatcher createPrefixMatcher(@NotNull CompletionParameters parameters) {
        CharSequence text = parameters.getPosition().getContainingFile().getViewProvider().getContents();
        int offset = parameters.getOffset();
        String prefix = CidrDebugConsoleCompletionContributor.getWordPrefix(text, offset).toString();
        return new PlainPrefixMatcher(prefix);
    }

    @NotNull
    private static CharSequence getWordPrefix(@NotNull CharSequence text, int offset) {
        int startOffset = CidrDebugConsoleCompletionContributor.getWordStartOffset(text, offset);
        return text.subSequence(startOffset, offset);
    }

    private static int getWordStartOffset(@NotNull CharSequence text, int offset) {
        for (int i = offset; i > 0; --i) {
            if (!Character.isWhitespace(text.charAt(i - 1))) continue;
            return i;
        }
        return 0;
    }
}

