/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.jetbrains.cidr.NamedPipe;
import com.pty4j.windows.CygwinPTYInputStream;
import com.pty4j.windows.CygwinPTYOutputStream;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WinPipe
implements NamedPipe {
    private static final int PIPE_ACCESS_INBOUND = 1;
    private static final int PIPE_ACCESS_OUTBOUND = 2;
    private static final AtomicInteger ourProcessCounter = new AtomicInteger();
    private final WinNT.HANDLE myHandle;
    @Nullable
    private volatile WinNT.HANDLE myShutdownEvent = null;
    private final com.pty4j.windows.NamedPipe myNamedPipe;
    private final String myPipeName;

    private WinPipe(int pipeDirectionFlag, @NotNull String nameSuffix) throws IOException {
        this.myPipeName = String.format("\\\\.\\pipe\\cidr-%d-%d-", Kernel32.INSTANCE.GetCurrentProcessId(), ourProcessCounter.getAndIncrement()) + nameSuffix;
        WinNT.HANDLE handle = Kernel32.INSTANCE.CreateNamedPipe(this.myPipeName, pipeDirectionFlag | 0x40000000, 0, 1, 0, 0, 0, null);
        if (handle == WinBase.INVALID_HANDLE_VALUE) {
            throw new IOException("Unable to create a named pipe");
        }
        this.myHandle = handle;
        this.myNamedPipe = new com.pty4j.windows.NamedPipe(handle, false);
    }

    @NotNull
    public static WinPipe createOutboundPipe(@NotNull String nameSuffix) throws IOException {
        return new WinPipe(2, nameSuffix);
    }

    @NotNull
    public static WinPipe createInboundPipe(@NotNull String nameSuffix) throws IOException {
        return new WinPipe(1, nameSuffix);
    }

    @Override
    @NotNull
    public String getName() {
        return this.myPipeName;
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        return new CygwinPTYInputStream(this.myNamedPipe);
    }

    @Override
    @NotNull
    public OutputStream getOutputStream() {
        return new CygwinPTYOutputStream(this.myNamedPipe);
    }

    @Override
    public void close() throws IOException {
        this.myNamedPipe.close();
        WinNT.HANDLE shutdownEvent = this.myShutdownEvent;
        if (shutdownEvent != null) {
            Kernel32.INSTANCE.SetEvent(shutdownEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean waitForConnection() throws IOException {
        WinNT.HANDLE connectEvent;
        this.myShutdownEvent = Kernel32.INSTANCE.CreateEvent(null, true, false, null);
        WinBase.OVERLAPPED overlapped = new WinBase.OVERLAPPED();
        overlapped.hEvent = connectEvent = Kernel32.INSTANCE.CreateEvent(null, true, false, null);
        WinNT.HANDLE[] connectWaitHandles = new WinNT.HANDLE[]{connectEvent, this.myShutdownEvent};
        try {
            int lastError;
            boolean success = Kernel32.INSTANCE.ConnectNamedPipe(this.myHandle, overlapped);
            if (!success && (lastError = Kernel32.INSTANCE.GetLastError()) != 535 && lastError != 997) {
                throw new IOException(String.format("Can't connect to pipe '%s': code %x", this.myPipeName, lastError));
            }
            int waitRet = Kernel32.INSTANCE.WaitForMultipleObjects(connectWaitHandles.length, connectWaitHandles, false, -1);
            if (waitRet != 0 && waitRet != 1) {
                int lastError2 = Kernel32.INSTANCE.GetLastError();
                throw new IOException(String.format("Wait for connection to pipe '%s' failed: code %x", this.myPipeName, lastError2));
            }
            boolean bl = waitRet == 0;
            return bl;
        }
        finally {
            Kernel32.INSTANCE.CloseHandle(connectEvent);
            WinNT.HANDLE shutdownEvent = this.myShutdownEvent;
            this.myShutdownEvent = null;
            Kernel32.INSTANCE.CloseHandle(shutdownEvent);
        }
    }
}

