/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.BaseOutputReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GLogOutputReaders {
    public static final Logger LOG = Logger.getInstance(GLogOutputReaders.class);
    private volatile List<MyLogReader> myReaders = new LinkedList<MyLogReader>();
    @NotNull
    private final File myLogDir;
    @NlsSafe
    @NotNull
    private final String myLogName;

    public GLogOutputReaders(@NotNull File logDir, @NlsSafe @NotNull String logName) {
        this.myLogDir = logDir;
        this.myLogName = logName;
    }

    public void init() {
        this.myReaders.add(new MyLogReader(this.myLogDir, this.myLogName, LogType.INFO));
    }

    @NotNull
    public File getLogDir() {
        return this.myLogDir;
    }

    public void close() {
        List<MyLogReader> readers = this.myReaders;
        this.myReaders = Collections.emptyList();
        for (MyLogReader each : readers) {
            each.stop();
        }
        for (MyLogReader each : readers) {
            try {
                each.waitFor();
            }
            catch (InterruptedException ignore) {
                Thread.interrupted();
                break;
            }
        }
        for (MyLogReader each : readers) {
            File file = each.getFile();
            if (!file.exists()) continue;
            FileUtil.delete((File)file);
        }
    }

    protected abstract void onTextAvailable(@NotNull String var1, @NotNull LogType var2);

    private final class MyLogReader {
        @NotNull
        private final File myFile;
        @NotNull
        private final LogType myType;
        @Nullable
        private volatile BaseOutputReader myReader;
        private volatile boolean closed;

        private MyLogReader(@NlsSafe @NotNull File dir, @NotNull String name, LogType type) {
            this.myFile = new File(dir, name + "." + type.toString());
            this.myType = type;
            if (this.myFile.exists()) {
                FileUtil.delete((File)this.myFile);
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                while (!this.closed && !this.myFile.exists()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        LOG.warn((Throwable)e);
                        break;
                    }
                }
                if (this.myFile.exists()) {
                    try {
                        this.start("log: " + this.myFile.getName());
                    }
                    catch (IOException e) {
                        LOG.warn((Throwable)e);
                    }
                }
            });
        }

        private void start(final @NotNull String presentableName) throws IOException {
            this.myReader = new BaseOutputReader(new FileInputStream(this.myFile), null){
                {
                    super(arg0, arg1);
                    this.start(presentableName);
                }

                protected void onTextAvailable(@NotNull String text) {
                    GLogOutputReaders.this.onTextAvailable(text, MyLogReader.this.myType);
                }

                @NotNull
                protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
                    return ApplicationManager.getApplication().executeOnPooledThread(runnable);
                }
            };
        }

        private void stop() {
            BaseOutputReader reader = this.myReader;
            if (reader != null) {
                reader.stop();
            }
            this.closed = true;
        }

        private void waitFor() throws InterruptedException {
            BaseOutputReader reader = this.myReader;
            if (reader != null) {
                reader.waitFor();
            }
        }

        @NotNull
        private File getFile() {
            return this.myFile;
        }
    }

    public static enum LogType {
        INFO("INFO"),
        WARNING("WARNING"),
        ERROR("ERROR"),
        FATAL("FATAL");

        private final String myName;

        private LogType(String name) {
            this.myName = name;
        }

        public String toString() {
            return this.myName;
        }
    }
}

