/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0014\u0010\f\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\b\u0010\r\u001a\u00020\bH\u0014J\b\u0010\u000e\u001a\u00020\bH\u0014J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH$J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0014J\u0014\u0010\u0014\u001a\u00020\b*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/VirtualFileChangeListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "coalesceChangesWithSameName", "", "(Z)V", "stack", "", "after", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "before", "begin", "done", "onFileChange", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "event", "triggerFileChanged", "fileChanged", "Companion", "intellij.cidr.util"})
public abstract class VirtualFileChangeListener
implements BulkFileListener {
    private int stack;
    private final boolean coalesceChangesWithSameName;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    protected void begin() {
    }

    protected void triggerFileChanged(@NotNull VirtualFile file, @NotNull VFileEvent event) {
        this.onFileChange(file, event);
    }

    protected abstract void onFileChange(@NotNull VirtualFile var1, @NotNull VFileEvent var2);

    protected void done() {
    }

    private final void fileChanged(VirtualFile $this$fileChanged, VFileEvent event) {
        if (!$this$fileChanged.isValid()) {
            LOG.warn((Throwable)((Object)new AssertionError((Object)("File " + $this$fileChanged + " is not valid directly before/after file change"))));
        } else {
            this.triggerFileChanged($this$fileChanged, event);
        }
    }

    public final void before(@NotNull List<? extends VFileEvent> events) {
        int n = this.stack;
        this.stack = n + 1;
        if (n == 0) {
            this.begin();
        }
        for (VFileEvent vFileEvent : events) {
            VFileEvent vFileEvent2 = vFileEvent;
            if (vFileEvent2 instanceof VFileMoveEvent) {
                this.fileChanged(((VFileMoveEvent)vFileEvent).getFile(), vFileEvent);
                continue;
            }
            if (vFileEvent2 instanceof VFilePropertyChangeEvent) {
                if (!com.jetbrains.cidr.VirtualFileChangeListener$Companion.isImportantPropertyChange$default(Companion, (VFilePropertyChangeEvent)vFileEvent, false, 2, null)) continue;
                this.fileChanged(((VFilePropertyChangeEvent)vFileEvent).getFile(), vFileEvent);
                continue;
            }
            if (!(vFileEvent2 instanceof VFileDeleteEvent)) continue;
            this.fileChanged(((VFileDeleteEvent)vFileEvent).getFile(), vFileEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void after(@NotNull List<? extends VFileEvent> events) {
        try {
            for (VFileEvent vFileEvent : events) {
                VFileEvent vFileEvent2 = vFileEvent;
                if (vFileEvent2 instanceof VFileMoveEvent) {
                    if (this.coalesceChangesWithSameName) continue;
                    this.fileChanged(((VFileMoveEvent)vFileEvent).getFile(), vFileEvent);
                    continue;
                }
                if (vFileEvent2 instanceof VFileCreateEvent) {
                    VirtualFile virtualFile = ((VFileCreateEvent)vFileEvent).getFile();
                    if (virtualFile != null) {
                        this.fileChanged(virtualFile, vFileEvent);
                    }
                    continue;
                }
                if (vFileEvent2 instanceof VFilePropertyChangeEvent) {
                    if (!VirtualFileChangeListener.Companion.isImportantPropertyChange((VFilePropertyChangeEvent)vFileEvent, this.coalesceChangesWithSameName)) continue;
                    this.fileChanged(((VFilePropertyChangeEvent)vFileEvent).getFile(), vFileEvent);
                    continue;
                }
                if (vFileEvent2 instanceof VFileContentChangeEvent) {
                    this.fileChanged(((VFileContentChangeEvent)vFileEvent).getFile(), vFileEvent);
                    continue;
                }
                if (!(vFileEvent2 instanceof VFileCopyEvent)) continue;
                VirtualFile virtualFile = ((VFileCopyEvent)vFileEvent).getNewParent().findChild(((VFileCopyEvent)vFileEvent).getNewChildName());
                if (virtualFile == null) continue;
                this.fileChanged(virtualFile, vFileEvent);
            }
            VirtualFileChangeListener virtualFileChangeListener = this;
            virtualFileChangeListener.stack += -1;
            if (virtualFileChangeListener.stack == 0) {
                this.done();
            }
        }
        catch (Throwable throwable) {
            VirtualFileChangeListener virtualFileChangeListener = this;
            virtualFileChangeListener.stack += -1;
            if (virtualFileChangeListener.stack == 0) {
                this.done();
            }
            throw throwable;
        }
    }

    public VirtualFileChangeListener(boolean coalesceChangesWithSameName) {
        this.coalesceChangesWithSameName = coalesceChangesWithSameName;
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(VirtualFileChangeListener.class);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0007H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/VirtualFileChangeListener$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "isImportantPropertyChange", "", "propertyChangeEvent", "Lcom/intellij/openapi/vfs/newvfs/events/VFilePropertyChangeEvent;", "ignoreSameName", "intellij.cidr.util"})
    public static final class Companion {
        private final boolean isImportantPropertyChange(VFilePropertyChangeEvent propertyChangeEvent, boolean ignoreSameName) {
            boolean bl;
            switch (propertyChangeEvent.getPropertyName()) {
                case "name": {
                    bl = Intrinsics.areEqual((Object)propertyChangeEvent.getOldValue(), (Object)propertyChangeEvent.getNewValue()) ^ true;
                    break;
                }
                case "symlink": {
                    if (!ignoreSameName) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }

        static /* synthetic */ boolean isImportantPropertyChange$default(Companion companion, VFilePropertyChangeEvent vFilePropertyChangeEvent, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.isImportantPropertyChange(vFilePropertyChangeEvent, bl);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

