/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.util.Version;
import com.intellij.util.VersionUtil;
import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class ToolVersion
implements Serializable {
    public static final String UNKNOWN_VERSION = "unknown";
    private static final Version NULL_VERSION = new Version(0, 0, 0);
    @NotNull
    public final String versionString;
    @NotNull
    public final Version versionNumber;

    public ToolVersion(int major, int minor, int bugfix) {
        this(Version.toCompactString((int)major, (int)minor, (int)bugfix), major, minor, bugfix);
    }

    public ToolVersion(@NotNull String versionString, int major, int minor, int bugfix) {
        this(versionString, new Version(major, minor, bugfix));
    }

    public ToolVersion(@NotNull String versionString, @NotNull Version versionNumber) {
        this.versionNumber = versionNumber;
        this.versionString = versionString;
    }

    public ToolVersion(@NotNull Version version) {
        this(version.toCompactString(), version);
    }

    @NotNull
    public static ToolVersion createUnknown(@NotNull String versionString) {
        return new ToolVersion(versionString, NULL_VERSION);
    }

    @NotNull
    public static ToolVersion parse(@NotNull String versionString, Pattern ... patterns) {
        Version version = VersionUtil.parseVersion((String)versionString, (Pattern[])patterns);
        return new ToolVersion(versionString, version != null ? version : NULL_VERSION);
    }

    public String toString() {
        return this.versionString;
    }

    @NotNull
    public String toCompactString() {
        return this.isUnknown() ? UNKNOWN_VERSION : this.versionNumber.toCompactString();
    }

    public boolean isUnknown() {
        return this.versionNumber == NULL_VERSION;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ToolVersion version = (ToolVersion)o;
        return this.isUnknown() == version.isUnknown() && Objects.equals(this.versionString, version.versionString) && Objects.equals(this.versionNumber, version.versionNumber);
    }

    public int hashCode() {
        return Objects.hash(this.isUnknown(), this.versionString, this.versionNumber);
    }
}

