/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PredefinedVariables {
    public static final String JETBRAINS_IDE = "JETBRAINS_IDE";

    @NotNull
    @NlsSafe
    public static List<String> getIDEVariables() {
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        if (applicationInfo == null) {
            return Collections.singletonList(JETBRAINS_IDE);
        }
        @NlsSafe String ideName = (StringUtil.toUpperCase((String)ApplicationNamesInfo.getInstance().getProductName()) + "_IDE").replaceAll("\\W", "_");
        return List.of(JETBRAINS_IDE, ideName);
    }

    @NotNull
    @NlsSafe
    public static String getVersionNumber() {
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        if (applicationInfo == null || ApplicationManager.getApplication().isUnitTestMode()) {
            return PredefinedVariables.toVersionNumber("2017.1");
        }
        return PredefinedVariables.toVersionNumber(applicationInfo.getFullVersion());
    }

    @NlsSafe
    static String toVersionNumber(@NlsSafe @NotNull String version) {
        ArrayList<String> parts = new ArrayList<String>(Arrays.asList(version.split("\\D")));
        while (parts.size() < 3) {
            parts.add("00");
        }
        Object major = (String)parts.get(0);
        Object minor = (String)parts.get(1);
        Object bugfix = (String)parts.get(2);
        if (((String)major).length() < 4) {
            major = StringUtil.repeat((String)"0", (int)(4 - ((String)major).length())) + (String)major;
        }
        if (((String)minor).length() < 2) {
            minor = StringUtil.repeat((String)"0", (int)(2 - ((String)minor).length())) + (String)minor;
        }
        if (((String)bugfix).length() < 2) {
            bugfix = StringUtil.repeat((String)"0", (int)(2 - ((String)bugfix).length())) + (String)bugfix;
        }
        return (String)major + (String)minor + (String)bugfix;
    }
}

