/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.google.common.collect.Maps;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.PathTreeBase;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PathTree<Self extends PathTree<Self, T>, T>
extends PathTreeBase<Self>
implements Cloneable {
    @Nullable
    protected Set<T> myItems;

    public PathTree() {
        this(true);
    }

    public PathTree(boolean resolveSymlinksIfNecessary) {
        super(resolveSymlinksIfNecessary);
    }

    @NotNull
    protected Set<T> createItemsSet(@Nullable Set<T> existing) {
        return existing != null ? new HashSet<T>(existing) : new HashSet();
    }

    public void addItem(@NotNull String path, @NotNull T item) {
        PathTree subTree = (PathTree)this.getNotNullSubTree(path);
        subTree.getItemsForWrite().add(item);
    }

    public void addItems(@NotNull String path, T ... items) {
        PathTree subTree = (PathTree)this.getNotNullSubTree(path);
        ContainerUtil.addAll(subTree.getItemsForWrite(), (Object[])items);
    }

    public int removeItem(@NotNull String path, @NotNull T ref) {
        Set<T> references;
        PathTree subTree = (PathTree)this.getSubTree(path, PathTreeBase.SearchStrategy.NULL_IF_NOT_FOUND);
        if (subTree != null && (references = subTree.myItems) != null) {
            references.remove(ref);
            return references.size();
        }
        return 0;
    }

    @NotNull
    public Set<T> getItems() {
        return this.myItems == null ? Collections.emptySet() : this.myItems;
    }

    @NotNull
    Set<T> getItemsForWrite() {
        return this.myItems == null ? (this.myItems = this.createItemsSet(null)) : this.myItems;
    }

    @Override
    Self clone(@Nullable Self parent) {
        PathTree clone = (PathTree)super.clone(parent);
        Set<T> items = this.myItems;
        clone.myItems = items == null ? null : this.createItemsSet(items);
        return (Self)clone;
    }

    @Override
    protected void mergeInto(@NotNull Self mergedTree, @NotNull MultiMap<String, Self> childrenPerKey) {
        super.mergeInto(mergedTree, childrenPerKey);
        Set<T> items = this.myItems;
        if (items != null) {
            ((PathTree)mergedTree).getItemsForWrite().addAll(items);
        }
    }

    @Override
    public String toString() {
        if (this.guaranteedToBeEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder(1024).append('{');
        this.accept(new PathTreeBase.ToStringVisitor(sb));
        return sb.append('}').toString();
    }

    @Override
    protected boolean isLeaf() {
        return !ContainerUtil.isEmpty(this.myItems);
    }

    @Override
    protected void nodeToString(@NotNull StringBuilder sb, @Nullable String path) {
        super.nodeToString(sb, path);
        sb.append('=').append(this.myItems);
    }

    @Override
    @NotNull
    protected Object nodeDebugRenderer(@Nullable String path) {
        return Maps.immutableEntry((Object)super.nodeDebugRenderer(path), this.myItems);
    }
}

