/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.cidr.ArchitectureType;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;

public final class ExecutableFileFormatUtil {
    @NotNull
    public static ArchitectureType tryReadElfMachineType(@NlsSafe @NotNull String path) {
        try {
            return ExecutableFileFormatUtil.readElfMachineType(path);
        }
        catch (IOException e) {
            return ArchitectureType.UNKNOWN;
        }
    }

    @NotNull
    public static ArchitectureType tryReadPeMachineType(@NlsSafe @NotNull String path) {
        try {
            return ExecutableFileFormatUtil.readPeMachineType(path);
        }
        catch (IOException e) {
            return ArchitectureType.UNKNOWN;
        }
    }

    @NotNull
    public static ArchitectureType readElfMachineType(@NlsSafe @NotNull String path) throws IOException {
        return ExecutableFileFormatUtil.readElfMachineType(Paths.get(path, new String[0]));
    }

    @NotNull
    public static ArchitectureType readPeMachineType(@NlsSafe @NotNull String path) throws IOException {
        return ExecutableFileFormatUtil.readPeMachineType(Paths.get(path, new String[0]));
    }

    @NotNull
    public static ArchitectureType readElfMachineType(@NotNull Path file) throws IOException {
        if (!Files.isRegularFile(file, new LinkOption[0]) || !Files.isReadable(file)) {
            throw new IOException("Not a readable file");
        }
        long len = Files.size(file);
        if (len < 0L) {
            throw new IOException("File length reported negative");
        }
        try (SeekableByteChannel channel = Files.newByteChannel(file, new OpenOption[0]);){
            int ELF_HEADER_LEN = 20;
            ByteBuffer elfHeader = ByteBuffer.allocate(20);
            if (channel.read(elfHeader) < 20) {
                throw new IOException("Not a valid ELF executable: ELF header is too short");
            }
            elfHeader.flip();
            if (elfHeader.getInt() != 2135247942) {
                throw new IOException("Not a valid ELF executable: missing ELF magic");
            }
            elfHeader.position(18);
            short elfMachineType = elfHeader.order(ByteOrder.LITTLE_ENDIAN).getShort();
            ArchitectureType architectureType = ArchitectureType.forElfMachineType(elfMachineType);
            return architectureType;
        }
    }

    @NotNull
    public static ArchitectureType readPeMachineType(@NotNull Path file) throws IOException {
        if (!Files.isRegularFile(file, new LinkOption[0]) || !Files.isReadable(file)) {
            throw new IOException("Not a readable file");
        }
        long len = Files.size(file);
        if (len < 0L) {
            throw new IOException("File length reported negative");
        }
        try (SeekableByteChannel channel = Files.newByteChannel(file, new OpenOption[0]);){
            int DOS_HEADER_LEN = 64;
            ByteBuffer dosHeader = ByteBuffer.allocate(64);
            if (channel.read(dosHeader) < 64) {
                throw new IOException("Not a valid PE executable: DOS header is too short");
            }
            dosHeader.flip();
            if (dosHeader.getShort() != 19802) {
                throw new IOException("Not a valid PE executable: missing DOS magic");
            }
            dosHeader.position(60);
            int peOffset = dosHeader.order(ByteOrder.LITTLE_ENDIAN).getInt();
            channel.position(peOffset);
            int PE_HEADER_LEN = 6;
            ByteBuffer peHeader = ByteBuffer.allocate(6);
            if (channel.read(peHeader) < 6) {
                throw new IOException("Not a valid PE executable: PE header is too short");
            }
            peHeader.flip();
            if (peHeader.getInt() != 0x50450000) {
                throw new IOException("Not a valid PE executable: missing PE magic");
            }
            short peMachineType = peHeader.order(ByteOrder.LITTLE_ENDIAN).getShort();
            ArchitectureType architectureType = ArchitectureType.forPeMachineType(peMachineType);
            return architectureType;
        }
    }
}

