/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public final class EscapeUtil {
    @NotNull
    public static String escapeGNU(String arg, boolean isShell) {
        if (arg.length() == 0) {
            return "\"\"";
        }
        StringBuilder result2 = new StringBuilder();
        int length = arg.length();
        for (int i = 0; i < length; ++i) {
            char c = arg.charAt(i);
            if ("\"' \\\t\n\r\f".indexOf(c) != -1 || isShell && "|&;<>()$`".indexOf(c) != -1) {
                result2.append('\\');
            }
            result2.append(c);
        }
        return result2.toString();
    }

    @NlsSafe
    @NotNull
    public static String escapeStringExceptUnicode(@NlsSafe @NotNull String content) {
        StringBuilder builder = new StringBuilder();
        StringUtil.escapeStringCharacters((int)content.length(), (String)content, (String)"\"", (boolean)true, (boolean)false, (StringBuilder)builder);
        return builder.toString();
    }

    @NotNull
    public static String unescapeAnsiStringCharacters(@NotNull String s) {
        return StringUtil.unescapeAnsiStringCharacters((String)s);
    }
}

