/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutlib;

import com.android.ide.common.rendering.api.Bridge;
import com.android.io.IAbstractFile;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.tools.idea.io.BufferingFileWrapper;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.layoutlib.LayoutLogWrapper;
import com.android.tools.idea.layoutlib.LayoutlibBundle;
import com.android.tools.idea.layoutlib.LogWrapper;
import com.android.tools.idea.layoutlib.RenderingException;
import com.android.utils.ILogger;
import com.intellij.internal.statistic.analytics.StudioCrashDetails;
import com.intellij.internal.statistic.analytics.StudioCrashDetection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.system.CpuArch;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class LayoutLibraryLoader {
    protected static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.uipreview.LayoutLibraryLoader");
    private static final Map<IAndroidTarget, LayoutLibrary> ourLibraryCache = ContainerUtil.createWeakKeySoftValueMap();

    private LayoutLibraryLoader() {
    }

    @NotNull
    private static LayoutLibrary loadImpl(@NotNull IAndroidTarget target, @NotNull Map<String, Map<String, Integer>> enumMap) throws RenderingException {
        Path fontFolderPath = target.getPath(12);
        VirtualFile fontFolder = LocalFileSystem.getInstance().findFileByNioFile(fontFolderPath);
        if (fontFolder == null || !fontFolder.isDirectory()) {
            throw new RenderingException(LayoutlibBundle.message("android.directory.cannot.be.found.error", fontFolderPath), new Throwable[0]);
        }
        String platformFolderPath = target.isPlatform() ? target.getLocation() : target.getParent().getLocation();
        File platformFolder = new File(platformFolderPath);
        if (!platformFolder.isDirectory()) {
            throw new RenderingException(LayoutlibBundle.message("android.directory.cannot.be.found.error", FileUtil.toSystemDependentName((String)platformFolderPath)), new Throwable[0]);
        }
        File buildProp = new File(platformFolder, "build.prop");
        if (!buildProp.isFile()) {
            throw new RenderingException(LayoutlibBundle.message("android.file.not.exist.error", FileUtil.toSystemDependentName((String)buildProp.getPath())), new Throwable[0]);
        }
        LogWrapper logger = new LogWrapper(LOG);
        Map<String, String> buildPropMap = ProjectProperties.parsePropertyFile((IAbstractFile)new BufferingFileWrapper(buildProp), (ILogger)logger);
        LayoutLogWrapper layoutLog = new LayoutLogWrapper(LOG);
        String dataPath = FileUtil.toSystemIndependentName((String)target.getPath(7).toString());
        String[] keyboardPaths = new String[]{dataPath + "/keyboards/Generic.kcm"};
        LayoutLibrary library = (LayoutLibrary)LayoutLibraryProvider.EP_NAME.computeSafeIfAny(LayoutLibraryProvider::getLibrary);
        if (library == null || !library.init(buildPropMap != null ? buildPropMap : Collections.emptyMap(), new File(fontFolder.getPath()), LayoutLibraryLoader.getNativeLibraryPath(dataPath), dataPath + "/icu/icudt70l.dat", keyboardPaths, enumMap, layoutLog)) {
            throw new RenderingException(LayoutlibBundle.message("layoutlib.init.failed", new Object[0]), new Throwable[0]);
        }
        return library;
    }

    @NotNull
    private static String getNativeLibraryPath(@NotNull String dataPath) {
        return dataPath + "/" + LayoutLibraryLoader.getPlatformName() + "/lib64/";
    }

    @NotNull
    private static String getPlatformName() {
        if (SystemInfo.isWindows) {
            return "win";
        }
        if (SystemInfo.isMac) {
            return CpuArch.isArm64() ? "mac-arm" : "mac";
        }
        if (SystemInfo.isLinux) {
            return "linux";
        }
        return "";
    }

    @NotNull
    public static synchronized LayoutLibrary load(@NotNull IAndroidTarget target, @NotNull Map<String, Map<String, Integer>> enumMap) throws RenderingException {
        if (Bridge.hasNativeCrash()) {
            throw new RenderingException("Rendering disabled following a crash", new Throwable[0]);
        }
        LayoutLibrary library = ourLibraryCache.get(target);
        if (library == null || library.isDisposed()) {
            List crashes = StudioCrashDetection.reapCrashDescriptions();
            for (StudioCrashDetails crash : crashes) {
                if (!LayoutLibraryLoader.isCrashCausedByLayoutlib(crash)) continue;
                Bridge.setNativeCrash((boolean)true);
                throw new RenderingException("Rendering disabled following a crash", new Throwable[0]);
            }
            library = LayoutLibraryLoader.loadImpl(target, enumMap);
            ourLibraryCache.put(target, library);
        }
        return library;
    }

    private static boolean isCrashCausedByLayoutlib(@NotNull StudioCrashDetails crash) {
        return crash.isJvmCrash() && (crash.getErrorThread().contains("Layoutlib Render Thread") || crash.getErrorFrame().contains("libandroid_runtime"));
    }

    public static abstract class LayoutLibraryProvider {
        public static final ExtensionPointName<LayoutLibraryProvider> EP_NAME = new ExtensionPointName("com.android.tools.idea.layoutlib.layoutLibraryProvider");

        @NotNull
        public abstract LayoutLibrary getLibrary();

        @NotNull
        public abstract Class<?> getFrameworkRClass();
    }
}

