/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.youtrack.model;

import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YouTrackIssue {
    public static final String DEFAULT_FIELDS = "idReadable,updated,created,resolved,summary,description,customFields(name,value(name))";
    @SerializedName(value="idReadable")
    private String id;
    private String summary;
    private String description;
    private long created;
    private long updated;
    private long resolved;
    private List<CustomField> customFields;

    @NotNull
    @NlsSafe
    public String getId() {
        return this.id;
    }

    @NotNull
    @NlsSafe
    public String getSummary() {
        return this.summary;
    }

    @NotNull
    @NlsSafe
    public String getDescription() {
        return StringUtil.notNullize((String)this.description);
    }

    public long getCreated() {
        return this.created;
    }

    public long getUpdated() {
        return this.updated;
    }

    public long getResolved() {
        return this.resolved;
    }

    @NotNull
    public List<CustomField> getCustomFields() {
        return ContainerUtil.notNullize(this.customFields);
    }

    public static class CustomField {
        private String name;
        private JsonElement value;

        @NotNull
        public String getName() {
            return this.name;
        }

        @Nullable
        public JsonElement getValue() {
            return this.value;
        }
    }
}

