/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.pivotal;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.gson.TaskGsonUtil;
import com.intellij.tasks.impl.httpclient.NewBaseRepositoryImpl;
import com.intellij.tasks.impl.httpclient.TaskResponseUtil;
import com.intellij.tasks.pivotal.PivotalTrackerRepositoryType;
import com.intellij.tasks.pivotal.PivotalTrackerTask;
import com.intellij.tasks.pivotal.model.PivotalTrackerStory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="PivotalTracker")
public class PivotalTrackerRepository
extends NewBaseRepositoryImpl {
    private static final Logger LOG = Logger.getInstance(PivotalTrackerRepository.class);
    private static final String API_V5_PATH = "/services/v5";
    private static final String TOKEN_HEADER = "X-TrackerToken";
    private static final Pattern TASK_ID_REGEX = Pattern.compile("(?<projectId>\\d+)-(?<storyId>\\d+)");
    private static final List<String> STANDARD_STORY_STATES = Arrays.asList("accepted", "delivered", "finished", "started", "rejected", "planned", "unstarted", "unscheduled");
    private static final TypeToken<List<PivotalTrackerStory>> LIST_OF_STORIES_TYPE = new TypeToken<List<PivotalTrackerStory>>(){};
    public static final Gson ourGson = TaskGsonUtil.createDefaultBuilder().create();
    private String myProjectId;
    private String myAPIKey;

    public PivotalTrackerRepository() {
        if (StringUtil.isEmpty((String)this.getUrl())) {
            this.setUrl("https://www.pivotaltracker.com");
        }
        this.myCommitMessageFormat = "[fixes #{number}] {summary}";
    }

    public PivotalTrackerRepository(PivotalTrackerRepositoryType type) {
        super(type);
        if (StringUtil.isEmpty((String)this.getUrl())) {
            this.setUrl("https://www.pivotaltracker.com");
        }
    }

    private PivotalTrackerRepository(PivotalTrackerRepository other) {
        super(other);
        if (StringUtil.isEmpty((String)this.getUrl())) {
            this.setUrl("https://www.pivotaltracker.com");
        }
        this.setProjectId(other.myProjectId);
    }

    @Override
    @NotNull
    public String getRestApiPathPrefix() {
        return API_V5_PATH;
    }

    @Override
    @Nullable
    protected HttpRequestInterceptor createRequestInterceptor() {
        return new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                request.addHeader(PivotalTrackerRepository.TOKEN_HEADER, PivotalTrackerRepository.this.getPassword());
            }
        };
    }

    @Nullable
    public TaskRepository.CancellableConnection createCancellableConnection() {
        return new NewBaseRepositoryImpl.HttpTestConnection((HttpRequestBase)new HttpGet()){

            @Override
            protected void doTest() throws Exception {
                this.myCurrentRequest = PivotalTrackerRepository.this.createStoriesRequest("", 0, 10, false);
                super.doTest();
            }
        };
    }

    public boolean isConfigured() {
        return super.isConfigured() && StringUtil.isNotEmpty((String)this.getProjectId()) && StringUtil.isNotEmpty((String)this.getPassword());
    }

    public Task[] getIssues(@Nullable String query, int offset, int limit, boolean withClosed) throws Exception {
        List stories = (List)this.getHttpClient().execute((HttpUriRequest)this.createStoriesRequest(query, offset, limit, withClosed), new TaskResponseUtil.GsonMultipleObjectsDeserializer<PivotalTrackerStory>(ourGson, LIST_OF_STORIES_TYPE));
        return (Task[])ContainerUtil.map2Array((Collection)stories, PivotalTrackerTask.class, story -> new PivotalTrackerTask(this, (PivotalTrackerStory)story));
    }

    @NotNull
    protected HttpGet createStoriesRequest(@Nullable String query, int offset, int limit, boolean withClosed) throws URISyntaxException {
        URI endpointUrl = new URIBuilder(this.getRestApiUrl("projects", this.myProjectId, "stories")).addParameter("filter", (withClosed ? "" : "state:started,unstarted,unscheduled,rejected") + (String)(StringUtil.isEmpty((String)query) ? "" : " \"" + query + "\"")).addParameter("offset", String.valueOf(offset)).addParameter("limit", String.valueOf(limit)).build();
        return new HttpGet(endpointUrl);
    }

    @Nullable
    public Task findTask(@NotNull String id) throws Exception {
        Matcher matcher = TASK_ID_REGEX.matcher(id);
        if (!matcher.matches()) {
            LOG.warn("Illegal PivotalTracker ID pattern " + id);
            return null;
        }
        String projectId = matcher.group("projectId");
        String storyId = matcher.group("storyId");
        PivotalTrackerStory story = (PivotalTrackerStory)this.getHttpClient().execute((HttpUriRequest)new HttpGet(this.getRestApiUrl("projects", projectId, "stories", storyId)), new TaskResponseUtil.GsonSingleObjectDeserializer<PivotalTrackerStory>(ourGson, PivotalTrackerStory.class, true));
        return story != null ? new PivotalTrackerTask(this, story) : null;
    }

    @Override
    @Nullable
    public String extractId(@NotNull String taskName) {
        Matcher matcher = TASK_ID_REGEX.matcher(taskName);
        return matcher.matches() ? taskName : null;
    }

    public void setTaskState(@NotNull Task task, @NotNull CustomTaskState state) throws Exception {
        Matcher matcher = TASK_ID_REGEX.matcher(task.getId());
        if (!matcher.matches()) {
            LOG.warn("Illegal PivotalTracker ID pattern " + task.getId());
            return;
        }
        String projectId = matcher.group("projectId");
        String storyId = matcher.group("storyId");
        HttpPut request = new HttpPut(this.getRestApiUrl("projects", projectId, "stories", storyId));
        String payload = ourGson.toJson(Map.of("current_state", state.getId()));
        request.setEntity((HttpEntity)new StringEntity(payload, ContentType.APPLICATION_JSON));
        this.getHttpClient().execute((HttpUriRequest)request);
    }

    @NotNull
    public Set<CustomTaskState> getAvailableTaskStates(@NotNull Task task) throws Exception {
        return ContainerUtil.map2Set(STANDARD_STORY_STATES, name -> new CustomTaskState(name, name));
    }

    @Override
    @NotNull
    public BaseRepository clone() {
        return new PivotalTrackerRepository(this);
    }

    public String getProjectId() {
        return this.myProjectId;
    }

    public void setProjectId(String projectId) {
        this.myProjectId = projectId;
    }

    public String getPresentableName() {
        String name = super.getPresentableName();
        return name + (String)(!StringUtil.isEmpty((String)this.getProjectId()) ? "/" + this.getProjectId() : "");
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof PivotalTrackerRepository)) {
            return false;
        }
        PivotalTrackerRepository that = (PivotalTrackerRepository)((Object)o);
        return !(this.getProjectId() != null ? !this.getProjectId().equals(that.getProjectId()) : that.getProjectId() != null);
    }

    protected int getFeatures() {
        return super.getFeatures() | 1 | 8;
    }

    @Override
    public void setUrl(String url) {
        if (((String)url).startsWith("http:")) {
            url = "https:" + StringUtil.trimStart((String)url, (String)"http:");
        }
        super.setUrl((String)url);
    }
}

