/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira;

import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.jira.JiraRepository;
import com.intellij.tasks.jira.rest.api2.JiraRestApi2;
import com.intellij.tasks.jira.rest.api20alpha1.JiraRestApi20Alpha1;
import com.intellij.tasks.jira.soap.JiraLegacyApi;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JiraRemoteApi {
    protected final JiraRepository myRepository;

    protected JiraRemoteApi(@NotNull JiraRepository repository) {
        this.myRepository = repository;
    }

    @NotNull
    public abstract List<Task> findTasks(@NotNull String var1, int var2) throws Exception;

    @Nullable
    public abstract Task findTask(@NotNull String var1) throws Exception;

    @NotNull
    public abstract Set<CustomTaskState> getAvailableTaskStates(@NotNull Task var1) throws Exception;

    public abstract void setTaskState(@NotNull Task var1, @NotNull CustomTaskState var2) throws Exception;

    public abstract void updateTimeSpend(@NotNull LocalTask var1, @NotNull String var2, String var3) throws Exception;

    @NotNull
    public final String getVersionName() {
        return this.getType().getVersionName();
    }

    public final String toString() {
        return "JiraRemoteApi(" + this.getType().getVersionName() + ")";
    }

    @NotNull
    public abstract ApiType getType();

    public static enum ApiType {
        LEGACY("XML-RPC + RSS"){

            @Override
            @NotNull
            public JiraLegacyApi createApi(@NotNull JiraRepository repository) {
                return new JiraLegacyApi(repository);
            }
        }
        ,
        REST_2_0("REST 2.0"){

            @Override
            @NotNull
            public JiraRestApi2 createApi(@NotNull JiraRepository repository) {
                return new JiraRestApi2(repository);
            }
        }
        ,
        REST_2_0_ALPHA("REST 2.0.alpha1"){

            @Override
            @NotNull
            public JiraRestApi20Alpha1 createApi(@NotNull JiraRepository repository) {
                return new JiraRestApi20Alpha1(repository);
            }
        };

        private final String myVersionName;

        private ApiType(String versionName) {
            this.myVersionName = versionName;
        }

        @NotNull
        public abstract JiraRemoteApi createApi(@NotNull JiraRepository var1);

        @NotNull
        public String getVersionName() {
            return this.myVersionName;
        }
    }
}

