/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.gitlab;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.gitlab.GitlabTask;
import com.intellij.tasks.gitlab.model.GitlabIssue;
import com.intellij.tasks.gitlab.model.GitlabProject;
import com.intellij.tasks.impl.gson.TaskGsonUtil;
import com.intellij.tasks.impl.httpclient.NewBaseRepositoryImpl;
import com.intellij.tasks.impl.httpclient.TaskResponseUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.protocol.HttpContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Tag(value="Gitlab")
public class GitlabRepository
extends NewBaseRepositoryImpl {
    private static final Logger LOG = Logger.getInstance(GitlabRepository.class);
    @NonNls
    private static final String TOKEN_HEADER = "PRIVATE-TOKEN";
    private static final Pattern ID_PATTERN = Pattern.compile("\\d+");
    private static final Gson GSON = TaskGsonUtil.createDefaultBuilder().create();
    private static final TypeToken<List<GitlabProject>> LIST_OF_PROJECTS_TYPE = new TypeToken<List<GitlabProject>>(){};
    private static final TypeToken<List<GitlabIssue>> LIST_OF_ISSUES_TYPE = new TypeToken<List<GitlabIssue>>(){};
    public static final GitlabProject UNSPECIFIED_PROJECT = GitlabRepository.createUnspecifiedProject();
    private GitlabProject myCurrentProject;
    private List<GitlabProject> myProjects = null;
    private ApiVersion myApiVersion = null;

    @NotNull
    private static GitlabProject createUnspecifiedProject() {
        GitlabProject unspecified = new GitlabProject(){

            @Override
            public String getName() {
                return "-- all issues created by you --";
            }
        };
        unspecified.setId(-1);
        return unspecified;
    }

    public GitlabRepository() {
    }

    public GitlabRepository(TaskRepositoryType type) {
        super(type);
    }

    public GitlabRepository(GitlabRepository other) {
        super(other);
        this.myCurrentProject = other.myCurrentProject;
        this.myApiVersion = other.myApiVersion;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        GitlabRepository repository = (GitlabRepository)((Object)o);
        if (!Comparing.equal((Object)this.myCurrentProject, (Object)repository.myCurrentProject)) {
            return false;
        }
        return Comparing.equal((Object)((Object)this.myApiVersion), (Object)((Object)repository.myApiVersion));
    }

    @Override
    @NotNull
    public GitlabRepository clone() {
        return new GitlabRepository(this);
    }

    public Task[] getIssues(@Nullable String query, int offset, int limit, boolean withClosed) throws Exception {
        List<GitlabIssue> issues = this.fetchIssues(offset / limit + 1, limit, !withClosed);
        return (Task[])ContainerUtil.map2Array(issues, GitlabTask.class, issue -> new GitlabTask(this, (GitlabIssue)issue));
    }

    @Nullable
    public Task findTask(@NotNull String id) throws Exception {
        return null;
    }

    @Nullable
    public TaskRepository.CancellableConnection createCancellableConnection() {
        return new NewBaseRepositoryImpl.HttpTestConnection((HttpRequestBase)new HttpGet()){

            @Override
            protected void test() throws Exception {
                this.myCurrentRequest = GitlabRepository.this.getApiVersionRequest();
                GitlabRepository.this.myApiVersion = GitlabRepository.this.fetchApiVersion((HttpGet)this.myCurrentRequest);
                this.myCurrentRequest = new HttpGet(GitlabRepository.this.getIssuesUrl());
                super.test();
            }
        };
    }

    @NotNull
    public List<GitlabProject> fetchProjects() throws Exception {
        this.ensureApiVersionDiscovered();
        TaskResponseUtil.GsonMultipleObjectsDeserializer<GitlabProject> handler = new TaskResponseUtil.GsonMultipleObjectsDeserializer<GitlabProject>(GSON, LIST_OF_PROJECTS_TYPE);
        String projectUrl = this.getRestApiUrl("projects");
        ArrayList<GitlabProject> result = new ArrayList<GitlabProject>();
        int pageNum = 1;
        while (true) {
            List page;
            URIBuilder paginatedProjectsUrl = new URIBuilder(projectUrl).addParameter("page", String.valueOf(pageNum)).addParameter("per_page", "30");
            if (this.myApiVersion == ApiVersion.V4) {
                paginatedProjectsUrl.addParameter("membership", "true");
            }
            if ((page = (List)this.getHttpClient().execute((HttpUriRequest)new HttpGet(paginatedProjectsUrl.build()), handler)).isEmpty()) break;
            result.addAll(page);
            ++pageNum;
        }
        this.myProjects = result;
        return Collections.unmodifiableList(this.myProjects);
    }

    @NotNull
    public GitlabProject fetchProject(int id) throws Exception {
        this.ensureApiVersionDiscovered();
        HttpGet request = new HttpGet(this.getRestApiUrl("project", id));
        return (GitlabProject)this.getHttpClient().execute((HttpUriRequest)request, new TaskResponseUtil.GsonSingleObjectDeserializer<GitlabProject>(GSON, GitlabProject.class));
    }

    @NotNull
    public List<GitlabIssue> fetchIssues(int pageNumber, int pageSize, boolean openedOnly) throws Exception {
        this.ensureApiVersionDiscovered();
        this.ensureProjectsDiscovered();
        URIBuilder uriBuilder = new URIBuilder(this.getIssuesUrl()).addParameter("page", String.valueOf(pageNumber)).addParameter("per_page", String.valueOf(pageSize)).addParameter("order_by", "updated_at");
        if (openedOnly) {
            uriBuilder.addParameter("state", "opened");
        }
        TaskResponseUtil.GsonMultipleObjectsDeserializer<GitlabIssue> handler = new TaskResponseUtil.GsonMultipleObjectsDeserializer<GitlabIssue>(GSON, LIST_OF_ISSUES_TYPE);
        return (List)this.getHttpClient().execute((HttpUriRequest)new HttpGet(uriBuilder.build()), handler);
    }

    private String getIssuesUrl() {
        if (this.myCurrentProject != null && this.myCurrentProject != UNSPECIFIED_PROJECT) {
            return this.getRestApiUrl("projects", this.myCurrentProject.getId(), "issues");
        }
        return this.getRestApiUrl("issues");
    }

    @Nullable
    public GitlabIssue fetchIssue(int projectId, int issueId) throws Exception {
        this.ensureApiVersionDiscovered();
        this.ensureProjectsDiscovered();
        HttpGet request = new HttpGet(this.getRestApiUrl("projects", projectId, "issues", issueId));
        TaskResponseUtil.GsonSingleObjectDeserializer<GitlabIssue> handler = new TaskResponseUtil.GsonSingleObjectDeserializer<GitlabIssue>(GSON, GitlabIssue.class, true);
        return (GitlabIssue)this.getHttpClient().execute((HttpUriRequest)request, handler);
    }

    public String getPresentableName() {
        Object name = this.getUrl();
        if (this.myCurrentProject != null && this.myCurrentProject != UNSPECIFIED_PROJECT) {
            name = (String)name + "/" + this.myCurrentProject.getName();
        }
        return name;
    }

    @Override
    @Nullable
    public String extractId(@NotNull String taskName) {
        return ID_PATTERN.matcher(taskName).matches() ? taskName : null;
    }

    public boolean isConfigured() {
        return super.isConfigured() && !this.myPassword.isEmpty();
    }

    @Override
    @NotNull
    public String getRestApiPathPrefix() {
        return "/api/" + (this.myApiVersion == ApiVersion.V4 ? "v4" : "v3") + "/";
    }

    @Override
    @Nullable
    protected HttpRequestInterceptor createRequestInterceptor() {
        return new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                request.addHeader(GitlabRepository.TOKEN_HEADER, GitlabRepository.this.myPassword);
            }
        };
    }

    public void setCurrentProject(@Nullable GitlabProject project) {
        this.myCurrentProject = project != null && project.getId() == -1 ? UNSPECIFIED_PROJECT : project;
    }

    public GitlabProject getCurrentProject() {
        return this.myCurrentProject;
    }

    @NotNull
    public List<GitlabProject> getProjects() {
        try {
            this.ensureProjectsDiscovered();
        }
        catch (Exception ignored) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.myProjects);
    }

    private void ensureProjectsDiscovered() throws Exception {
        if (this.myProjects == null) {
            this.fetchProjects();
        }
    }

    private void ensureApiVersionDiscovered() throws Exception {
        if (this.myApiVersion == null) {
            this.myApiVersion = this.fetchApiVersion(this.getApiVersionRequest());
        }
    }

    @NotNull
    private ApiVersion fetchApiVersion(@NotNull HttpGet request) throws IOException {
        HttpResponse response = this.getHttpClient().execute((HttpUriRequest)request);
        ApiVersion version = response.getStatusLine().getStatusCode() == 200 ? ApiVersion.V4 : ApiVersion.V3;
        LOG.debug("Version " + version + " of Gitlab API is discovered at " + this.getUrl());
        return version;
    }

    @NotNull
    private HttpGet getApiVersionRequest() {
        return new HttpGet(StringUtil.trimEnd((String)this.getUrl(), (String)"/") + "/api/v4/version");
    }

    @Transient
    @TestOnly
    public void setProjects(@NotNull List<GitlabProject> projects) {
        this.myProjects = projects;
    }

    protected int getFeatures() {
        int features = super.getFeatures();
        if (this.myApiVersion == ApiVersion.V4) {
            return features | 4;
        }
        return features;
    }

    public void updateTimeSpent(@NotNull LocalTask task, @NotNull String timeSpent, @NotNull String comment) throws Exception {
        this.ensureApiVersionDiscovered();
        Pattern issueURLPattern = Pattern.compile("https?://.*/([^/]*/[^/]*)/issues/\\d+");
        String issueURL = task.getIssueUrl();
        if (issueURL == null) {
            throw new IllegalArgumentException("A GitLab-bound LocalTask should not have a null issue url.");
        }
        Matcher issueURLMatcher = issueURLPattern.matcher(issueURL);
        if (!issueURLMatcher.matches()) {
            throw new IllegalStateException("Could not find project namespace from issue URL.");
        }
        String projectNamespace = issueURLMatcher.group(1);
        URI timeUpdateURI = new URIBuilder(this.getRestApiUrl("projects", projectNamespace, "issues", task.getNumber(), "add_spent_time")).addParameter("duration", timeSpent).build();
        LOG.debug("Sending POST request to " + timeUpdateURI);
        HttpPost timeUpdateRequest = new HttpPost(timeUpdateURI);
        HttpResponse timeUpdateResponse = this.getHttpClient().execute((HttpUriRequest)timeUpdateRequest);
        if (timeUpdateResponse.getStatusLine().getStatusCode() != 201) {
            LOG.error("Failed adding time spent to GitLab. Received error code: " + timeUpdateResponse.getStatusLine().getStatusCode());
            throw new RuntimeException("Could not add time to the remote task.");
        }
        if (!StringUtil.isEmptyOrSpaces((String)comment)) {
            URI addCommentURI = new URIBuilder(this.getRestApiUrl("projects", projectNamespace, "issues", task.getNumber(), "notes")).addParameter("body", comment).build();
            HttpPost addCommentRequest = new HttpPost(addCommentURI);
            HttpResponse addCommentResponse = this.getHttpClient().execute((HttpUriRequest)addCommentRequest);
            if (addCommentResponse.getStatusLine().getStatusCode() != 201) {
                LOG.error("Failed adding a comment to GitLab. Received error code: " + addCommentResponse.getStatusLine().getStatusCode());
                throw new RuntimeException("Could not add a comment to the remote task.");
            }
        }
    }

    static enum ApiVersion {
        V3,
        V4;

    }
}

