/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.generic;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import org.intellij.lang.regexp.RegExpFileType;
import org.jetbrains.annotations.NotNull;

public enum ResponseType {
    XML("application/xml", (FileType)XmlFileType.INSTANCE, ResponseType.findXPathFileType()),
    JSON("application/json", ResponseType.findFileTypePlainDefault("JSON"), (FileType)PlainTextFileType.INSTANCE),
    HTML("text/html", (FileType)HtmlFileType.INSTANCE, (FileType)PlainTextFileType.INSTANCE),
    TEXT("text/plain", (FileType)PlainTextFileType.INSTANCE, (FileType)RegExpFileType.INSTANCE);

    private final String myMimeType;
    private final FileType myContentFileType;
    private final FileType mySelectorFileType;
    private static Logger LOG;

    private ResponseType(@NotNull String s, FileType contentFileType, FileType selectorFileType) {
        this.myMimeType = s;
        this.myContentFileType = contentFileType;
        this.mySelectorFileType = selectorFileType;
    }

    @NotNull
    private static FileType findFileTypePlainDefault(@NotNull String name) {
        FileType fileType = FileTypeManager.getInstance().findFileTypeByName(name);
        return fileType == null ? PlainTextFileType.INSTANCE : fileType;
    }

    @NotNull
    private static FileType findXPathFileType() {
        if (LOG == null) {
            LOG = Logger.getInstance(ResponseType.class);
        }
        try {
            Class<?> xPathClass = Class.forName("org.intellij.lang.xpath.XPathFileType");
            LOG.debug("XPathFileType class loaded successfully");
            return (FileType)xPathClass.getField("XPATH").get(null);
        }
        catch (Exception e) {
            LOG.debug("XPathFileType class not found. Using PlainText.INSTANCE instead");
            return PlainTextFileType.INSTANCE;
        }
    }

    @NotNull
    public String getMimeType() {
        return this.myMimeType;
    }

    @NotNull
    public FileType getContentFileType() {
        return this.myContentFileType;
    }

    @NotNull
    public FileType getSelectorFileType() {
        return this.mySelectorFileType;
    }

    static {
        LOG = Logger.getInstance(ResponseType.class);
    }
}

