/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.generic;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.generic.Selector;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

class HighlightedSelectorsTable
extends TableView<Selector> {
    HighlightedSelectorsTable(final @NotNull FileType valueFileType, final @NotNull Project project, @NotNull List<Selector> selectors) {
        super(new ListTableModel(new ColumnInfo[]{new ColumnInfo<Selector, String>(TaskBundle.message((String)"column.name.name", (Object[])new Object[0])){

            @NotNull
            public String valueOf(Selector selector) {
                return selector.getName();
            }
        }, new ColumnInfo<Selector, String>(TaskBundle.message((String)"column.name.path", (Object[])new Object[0])){

            @NotNull
            public String valueOf(Selector selector) {
                return selector.getPath();
            }

            public boolean isCellEditable(Selector selector) {
                return true;
            }

            public void setValue(Selector selector, String value) {
                selector.setPath(value);
            }

            @NotNull
            public TableCellRenderer getRenderer(Selector selector) {
                return new EditorTableCellViewer(valueFileType, project);
            }

            @NotNull
            public TableCellEditor getEditor(Selector o) {
                return new EditorTableCellViewer(valueFileType, project);
            }
        }}, selectors, 0));
        this.setShowGrid(false);
    }

    private static final class EditorTableCellViewer
    extends AbstractTableCellEditor
    implements TableCellRenderer {
        private final EditorTextField myEditorField;

        private EditorTableCellViewer(FileType fileType, Project project) {
            this.myEditorField = new EditorTextField("", project, fileType);
        }

        public Object getCellEditorValue() {
            return this.myEditorField.getText();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.myEditorField.setText((String)value);
            return this.myEditorField;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.myEditorField.setText((String)value);
            return this.myEditorField;
        }
    }
}

