/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.generic;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositorySubtype;
import com.intellij.tasks.config.TaskRepositoryEditor;
import com.intellij.tasks.generic.GenericRepository;
import com.intellij.tasks.generic.GenericRepositoryEditor;
import com.intellij.tasks.impl.BaseRepositoryType;
import com.intellij.util.Consumer;
import com.intellij.util.xmlb.XmlSerializer;
import icons.TasksCoreIcons;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class GenericRepositoryType
extends BaseRepositoryType<GenericRepository> {
    @NotNull
    public String getName() {
        return "Generic";
    }

    @NotNull
    public Icon getIcon() {
        return AllIcons.General.Web;
    }

    @NotNull
    public TaskRepository createRepository() {
        return new GenericRepository(this);
    }

    public Class<GenericRepository> getRepositoryClass() {
        return GenericRepository.class;
    }

    @Override
    @NotNull
    public TaskRepositoryEditor createEditor(GenericRepository repository, Project project, Consumer<? super GenericRepository> changeListener) {
        return new GenericRepositoryEditor<GenericRepository>(project, repository, changeListener);
    }

    public List<TaskRepositorySubtype> getAvailableSubtypes() {
        return Arrays.asList(new TaskRepositorySubtype[]{this, new AsanaRepository(), new AssemblaRepository(), new SprintlyRepository()});
    }

    public final class SprintlyRepository
    extends GenericSubtype {
        public SprintlyRepository() {
            super("Sprintly", TasksCoreIcons.Sprintly);
        }
    }

    public final class AssemblaRepository
    extends GenericSubtype {
        public AssemblaRepository() {
            super("Assembla", TasksCoreIcons.Assembla);
        }
    }

    public final class AsanaRepository
    extends GenericSubtype {
        public AsanaRepository() {
            super("Asana", TasksCoreIcons.Asana);
        }
    }

    public class GenericSubtype
    implements TaskRepositorySubtype {
        private final String myName;
        private final Icon myIcon;

        GenericSubtype(String name, Icon icon) {
            this.myName = name;
            this.myIcon = icon;
        }

        public String getName() {
            return this.myName + " [G]";
        }

        public Icon getIcon() {
            return this.myIcon;
        }

        public TaskRepository createRepository() {
            Element element;
            try {
                String configFileName = StringUtil.toLowerCase((String)this.myName) + ".xml";
                URL resourceUrl = GenericRepository.class.getResource("connectors/" + configFileName);
                if (resourceUrl == null) {
                    throw new AssertionError((Object)("Repository configuration file '" + configFileName + "' not found"));
                }
                element = JDOMUtil.loadResource((URL)resourceUrl);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
            GenericRepository repository = (GenericRepository)((Object)XmlSerializer.deserialize((Element)element, GenericRepository.class));
            repository.setRepositoryType(GenericRepositoryType.this);
            repository.setSubtypeName(this.getName());
            return repository;
        }
    }
}

