/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.context.java;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.impl.DebuggerManagerImpl;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.context.WorkingContextProvider;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public final class BreakpointsContextProvider
extends WorkingContextProvider {
    @NotNull
    public String getId() {
        return "javaDebugger";
    }

    @NotNull
    public String getDescription() {
        return TaskBundle.message((String)"java.debugger.breakpoints", (Object[])new Object[0]);
    }

    public void saveContext(@NotNull Project project, @NotNull Element toElement) throws WriteExternalException {
        BreakpointsContextProvider.getBreakpointManager(project).writeExternal(toElement);
    }

    @NotNull
    private static BreakpointManager getBreakpointManager(@NotNull Project project) {
        return DebuggerManagerEx.getInstanceEx((Project)project).getBreakpointManager();
    }

    public void loadContext(@NotNull Project project, @NotNull Element fromElement) throws InvalidDataException {
        ((DebuggerManagerImpl)DebuggerManager.getInstance((Project)project)).loadState(fromElement);
    }

    public void clearContext(@NotNull Project project) {
        BreakpointManager breakpointManager = BreakpointsContextProvider.getBreakpointManager(project);
        for (Breakpoint breakpoint : breakpointManager.getBreakpoints()) {
            ApplicationManager.getApplication().runWriteAction(() -> breakpointManager.removeBreakpoint(breakpoint));
        }
    }
}

