/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.actions.BaseTaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenTaskInBrowserAction
extends BaseTaskAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        String url = OpenTaskInBrowserAction.getIssueUrl(e);
        if (url != null) {
            BrowserUtil.browse((String)url);
        }
    }

    @Override
    public void update(@NotNull AnActionEvent event) {
        super.update(event);
        if (event.getPresentation().isEnabled()) {
            Presentation presentation = event.getPresentation();
            String url = OpenTaskInBrowserAction.getIssueUrl(event);
            presentation.setEnabled(url != null);
            Project project = OpenTaskInBrowserAction.getProject(event);
            if (project == null || !TaskManager.getManager((Project)project).getActiveTask().isIssue()) {
                presentation.setText(this.getTemplatePresentation().getText());
            } else {
                presentation.setText(TaskBundle.message((String)"action.open.in.browser.text", (Object[])new Object[]{TaskManager.getManager((Project)project).getActiveTask().getPresentableName()}));
            }
        }
    }

    @Nullable
    private static String getIssueUrl(AnActionEvent event) {
        Project project = event.getProject();
        return project == null ? null : TaskManager.getManager((Project)project).getActiveTask().getIssueUrl();
    }
}

