/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang.java6;

import com.intellij.util.lang.java6.ClasspathCache;
import com.intellij.util.lang.java6.Resource;
import java.io.IOException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class Loader {
    @NotNull
    private final URL myURL;
    private ClasspathCache.NameFilter myLoadingFilter;

    Loader(@NotNull URL url) {
        this.myURL = url;
    }

    @NotNull
    URL getBaseURL() {
        return this.myURL;
    }

    @Nullable
    abstract Resource getResource(@NotNull String var1);

    @NotNull
    abstract ClasspathCache.LoaderData buildData() throws IOException;

    boolean containsName(@NotNull String name, @NotNull String shortName) {
        if (name.isEmpty()) {
            return true;
        }
        ClasspathCache.NameFilter filter = this.myLoadingFilter;
        return filter == null || filter.maybeContains(shortName);
    }

    void applyData(@NotNull ClasspathCache.LoaderData loaderData) {
        this.myLoadingFilter = loaderData.getNameFilter();
    }
}

