/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang.java6;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.lang.java6.ClassPath;
import com.intellij.util.lang.java6.ClasspathCache;
import com.intellij.util.lang.java6.Loader;
import com.intellij.util.lang.java6.Resource;
import com.intellij.util.lang.java6.fastutil.StrippedIntOpenHashSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JarLoader
extends Loader {
    private static final List<Map.Entry<Resource.Attribute, Attributes.Name>> PACKAGE_FIELDS = Arrays.asList(new AbstractMap.SimpleImmutableEntry<Resource.Attribute, Attributes.Name>(Resource.Attribute.SPEC_TITLE, Attributes.Name.SPECIFICATION_TITLE), new AbstractMap.SimpleImmutableEntry<Resource.Attribute, Attributes.Name>(Resource.Attribute.SPEC_VERSION, Attributes.Name.SPECIFICATION_VERSION), new AbstractMap.SimpleImmutableEntry<Resource.Attribute, Attributes.Name>(Resource.Attribute.SPEC_VENDOR, Attributes.Name.SPECIFICATION_VENDOR), new AbstractMap.SimpleImmutableEntry<Resource.Attribute, Attributes.Name>(Resource.Attribute.IMPL_TITLE, Attributes.Name.IMPLEMENTATION_TITLE), new AbstractMap.SimpleImmutableEntry<Resource.Attribute, Attributes.Name>(Resource.Attribute.IMPL_VERSION, Attributes.Name.IMPLEMENTATION_VERSION), new AbstractMap.SimpleImmutableEntry<Resource.Attribute, Attributes.Name>(Resource.Attribute.IMPL_VENDOR, Attributes.Name.IMPLEMENTATION_VENDOR));
    private static final String NULL_STRING = "<null>";
    private final String myFilePath;
    private final ClassPath myConfiguration;
    private final URL myUrl;
    private volatile SoftReference<ZipFile> myZipFileSoftReference;
    private volatile Map<Resource.Attribute, String> myAttributes;
    private volatile String myClassPathManifestAttribute;
    private final AtomicInteger myNumberOfRequests = new AtomicInteger();
    private volatile StrippedIntOpenHashSet myPackageHashesInside;
    private static final Object ourLock = new Object();

    JarLoader(@NotNull URL url, @NotNull String filePath, @NotNull ClassPath configuration) throws IOException {
        super(new URL("jar", "", -1, url + "!/"));
        this.myFilePath = filePath;
        this.myConfiguration = configuration;
        this.myUrl = url;
        if (!configuration.myLazyClassloadingCaches) {
            ZipFile zipFile = this.getZipFile();
            this.releaseZipFile(zipFile);
        }
    }

    @Nullable
    String getClassPathManifestAttribute() {
        this.loadManifestAttributes();
        String manifestAttribute = this.myClassPathManifestAttribute;
        return manifestAttribute != NULL_STRING ? manifestAttribute : null;
    }

    @Nullable
    private static Map<Resource.Attribute, String> getAttributes(@Nullable Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        EnumMap<Resource.Attribute, String> map = null;
        for (Map.Entry<Resource.Attribute, Attributes.Name> p : PACKAGE_FIELDS) {
            String value = attributes.getValue(p.getValue());
            if (value == null) continue;
            if (map == null) {
                map = new EnumMap<Resource.Attribute, String>(Resource.Attribute.class);
            }
            map.put(p.getKey(), value);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadManifestAttributes() {
        if (this.myClassPathManifestAttribute != null) {
            return;
        }
        JarLoader jarLoader = this;
        synchronized (jarLoader) {
            try {
                if (this.myClassPathManifestAttribute != null) {
                    return;
                }
                ZipFile zipFile = this.getZipFile();
                try {
                    Attributes manifestAttributes = this.myConfiguration.getManifestData(this.myUrl);
                    if (manifestAttributes == null) {
                        ZipEntry entry = zipFile.getEntry("META-INF/MANIFEST.MF");
                        if (entry != null) {
                            manifestAttributes = JarLoader.loadManifestAttributes(zipFile.getInputStream(entry));
                        }
                        if (manifestAttributes == null) {
                            manifestAttributes = new Attributes(0);
                        }
                        this.myConfiguration.cacheManifestData(this.myUrl, manifestAttributes);
                    }
                    this.myAttributes = JarLoader.getAttributes(manifestAttributes);
                    Object attribute = manifestAttributes.get(Attributes.Name.CLASS_PATH);
                    this.myClassPathManifestAttribute = attribute instanceof String ? (String)attribute : NULL_STRING;
                }
                finally {
                    this.releaseZipFile(zipFile);
                }
            }
            catch (IOException io) {
                throw new RuntimeException(io);
            }
        }
    }

    @Nullable
    private static Attributes loadManifestAttributes(InputStream stream) {
        Attributes attributes;
        try {
            attributes = new Manifest(stream).getMainAttributes();
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (Exception exception) {
                return null;
            }
        }
        stream.close();
        return attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ClasspathCache.LoaderData buildData() throws IOException {
        ZipFile zipFile = this.getZipFile();
        try {
            ClasspathCache.LoaderDataBuilder loaderDataBuilder = new ClasspathCache.LoaderDataBuilder();
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (name.endsWith(".class")) {
                    loaderDataBuilder.addClassPackageFromName(name);
                } else {
                    loaderDataBuilder.addResourcePackageFromName(name);
                }
                loaderDataBuilder.addPossiblyDuplicateNameEntry(name);
            }
            ClasspathCache.LoaderData loaderData = loaderDataBuilder.build();
            return loaderData;
        }
        finally {
            this.releaseZipFile(zipFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private StrippedIntOpenHashSet buildPackageHashes() {
        StrippedIntOpenHashSet strippedIntOpenHashSet;
        ZipFile zipFile = this.getZipFile();
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            StrippedIntOpenHashSet result = new StrippedIntOpenHashSet();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                result.add(ClasspathCache.getPackageNameHash(entry.getName()));
            }
            result.add(0);
            strippedIntOpenHashSet = result;
        }
        catch (Throwable throwable) {
            try {
                this.releaseZipFile(zipFile);
                throw throwable;
            }
            catch (Exception e) {
                this.error("url: " + this.myFilePath, e);
                return new StrippedIntOpenHashSet(0);
            }
        }
        this.releaseZipFile(zipFile);
        return strippedIntOpenHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    Resource getResource(@NotNull String name) {
        if (this.myConfiguration.myLazyClassloadingCaches) {
            int numberOfHits = this.myNumberOfRequests.incrementAndGet();
            StrippedIntOpenHashSet packagesInside = this.myPackageHashesInside;
            if (numberOfHits > 1000 && packagesInside == null) {
                this.myPackageHashesInside = packagesInside = this.buildPackageHashes();
            }
            if (packagesInside != null && !packagesInside.contains(ClasspathCache.getPackageNameHash(name))) {
                return null;
            }
        }
        try {
            ZipFile zipFile = this.getZipFile();
            try {
                ZipEntry entry = zipFile.getEntry(name);
                if (entry == null) return null;
                Resource resource = this.instantiateResource(this.getBaseURL(), entry);
                return resource;
            }
            finally {
                this.releaseZipFile(zipFile);
            }
        }
        catch (Exception e) {
            this.error("url: " + this.myFilePath, e);
        }
        return null;
    }

    @NotNull
    protected Resource instantiateResource(@NotNull URL url, @NotNull ZipEntry entry) throws IOException {
        return new MyResource(url, entry);
    }

    protected void error(@NotNull String message, @NotNull Throwable t) {
        if (this.myConfiguration.myLogErrorOnMissingJar) {
            LoggerRt.getInstance(JarLoader.class).error(message, t);
        } else {
            LoggerRt.getInstance(JarLoader.class).warn(message, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected ZipFile getZipFile() throws IOException {
        if (this.myConfiguration.myCanLockJars) {
            ZipFile zipFile;
            SoftReference<ZipFile> ref = this.myZipFileSoftReference;
            ZipFile zipFile2 = zipFile = ref == null ? null : ref.get();
            if (zipFile != null) {
                return zipFile;
            }
            Object object = ourLock;
            synchronized (object) {
                ref = this.myZipFileSoftReference;
                ZipFile zipFile3 = zipFile = ref == null ? null : ref.get();
                if (zipFile != null) {
                    return zipFile;
                }
                zipFile = this.createZipFile(this.myFilePath);
                this.myZipFileSoftReference = new SoftReference<ZipFile>(zipFile);
                return zipFile;
            }
        }
        return this.createZipFile(this.myFilePath);
    }

    @NotNull
    protected ZipFile createZipFile(@NotNull String path) throws IOException {
        return new ZipFile(path);
    }

    protected void releaseZipFile(@NotNull ZipFile zipFile) throws IOException {
        if (!this.myConfiguration.myCanLockJars) {
            zipFile.close();
        }
    }

    public String toString() {
        return "JarLoader [" + this.myFilePath + "]";
    }

    protected class MyResource
    extends Resource {
        protected final URL myUrl;
        protected final ZipEntry myEntry;

        MyResource(@NotNull URL url, ZipEntry entry) throws IOException {
            this.myUrl = new URL(url, entry.getName());
            this.myEntry = entry;
        }

        @Override
        @NotNull
        public URL getURL() {
            return this.myUrl;
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.getBytes());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public byte[] getBytes() throws IOException {
            ZipFile file = JarLoader.this.getZipFile();
            InputStream stream = null;
            try {
                stream = file.getInputStream(this.myEntry);
                byte[] byArray = FileUtilRt.loadBytes((InputStream)stream, (int)((int)this.myEntry.getSize()));
                return byArray;
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
                JarLoader.this.releaseZipFile(file);
            }
        }

        @Override
        public String getValue(@NotNull Resource.Attribute key) {
            JarLoader.this.loadManifestAttributes();
            return JarLoader.this.myAttributes != null ? (String)JarLoader.this.myAttributes.get((Object)key) : null;
        }
    }
}

