/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang.java6;

import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.lang.java6.ClassPath;
import com.intellij.util.lang.java6.ClasspathCache;
import com.intellij.util.lang.java6.Loader;
import com.intellij.util.lang.java6.Resource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FileLoader
extends Loader {
    private final File myRootDir;
    private final String myRootDirAbsolutePath;
    private final ClassPath myConfiguration;
    private final DirEntry root = new DirEntry(0, "");
    private static final AtomicInteger totalLoaders = new AtomicInteger();
    private static final AtomicLong totalScanning = new AtomicLong();
    private static final AtomicLong totalSaving = new AtomicLong();
    private static final AtomicLong totalReading = new AtomicLong();
    private static final Boolean doFsActivityLogging = false;
    private static final int ourVersion = 1;

    FileLoader(@NotNull URL url, @NotNull ClassPath configuration) throws IOException {
        super(url);
        try {
            this.myRootDir = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        this.myRootDirAbsolutePath = this.myRootDir.getAbsolutePath();
        this.myConfiguration = configuration;
    }

    private void buildPackageCache(@NotNull File dir, @NotNull ClasspathCache.LoaderDataBuilder context) {
        context.addResourcePackageFromName(this.getRelativeResourcePath(dir));
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        boolean containsClasses = false;
        for (File file : files) {
            boolean isClass = file.getPath().endsWith(".class");
            if (isClass) {
                if (!containsClasses) {
                    context.addClassPackageFromName(this.getRelativeResourcePath(file));
                    containsClasses = true;
                }
                context.addPossiblyDuplicateNameEntry(file.getName());
                continue;
            }
            context.addPossiblyDuplicateNameEntry(file.getName());
            this.buildPackageCache(file, context);
        }
    }

    @NotNull
    private String getRelativeResourcePath(@NotNull File file) {
        return this.getRelativeResourcePath(file.getAbsolutePath());
    }

    @NotNull
    private String getRelativeResourcePath(@NotNull String absFilePath) {
        String relativePath = absFilePath.substring(this.myRootDirAbsolutePath.length());
        relativePath = (relativePath = relativePath.replace(File.separatorChar, '/')).startsWith("/") ? relativePath.substring(1) : relativePath;
        return relativePath;
    }

    @Override
    @Nullable
    Resource getResource(@NotNull String name) {
        try {
            URL url;
            if (this.myConfiguration.myLazyClassloadingCaches) {
                DirEntry lastEntry = this.root;
                int prevIndex = 0;
                int nextIndex = name.indexOf(47, prevIndex);
                while (true) {
                    int nameEnd;
                    int nameHash;
                    if (!this.nameHashIsPresentInChildren(lastEntry, name, prevIndex, nameHash = StringUtilRt.stringHashCodeInsensitive((CharSequence)name, (int)prevIndex, (int)(nameEnd = nextIndex == -1 ? name.length() : nextIndex)))) {
                        return null;
                    }
                    if (nextIndex == -1 || nextIndex == name.length() - 1) break;
                    lastEntry = FileLoader.findOrCreateNextDirEntry(lastEntry, name, prevIndex, nameEnd, nameHash);
                    prevIndex = nextIndex + 1;
                    nextIndex = name.indexOf(47, prevIndex);
                }
            }
            if (!(url = new URL(this.getBaseURL(), name)).getFile().startsWith(this.getBaseURL().getFile())) {
                return null;
            }
            File file = new File(this.myRootDir, name.replace('/', File.separatorChar));
            if (file.exists()) {
                return new MyResource(url, file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    private static DirEntry findOrCreateNextDirEntry(@NotNull DirEntry lastEntry, @NotNull String name, int prevIndex, int nameEnd, int nameHash) {
        DirEntry nextEntry = null;
        DirEntry[] directories = lastEntry.childrenDirectories;
        if (directories != null) {
            int len = directories.length;
            for (int index = 0; index < len; ++index) {
                DirEntry previouslyScannedDir = directories[index];
                if (previouslyScannedDir.nameHash != nameHash || !previouslyScannedDir.name.regionMatches(0, name, prevIndex, nameEnd - prevIndex)) continue;
                nextEntry = previouslyScannedDir;
                break;
            }
        }
        if (nextEntry == null) {
            DirEntry[] newChildrenDirectories;
            nextEntry = new DirEntry(nameHash, name.substring(prevIndex, nameEnd));
            if (directories != null) {
                newChildrenDirectories = Arrays.copyOf(directories, directories.length + 1);
                newChildrenDirectories[directories.length] = nextEntry;
            } else {
                newChildrenDirectories = new DirEntry[]{nextEntry};
            }
            lastEntry.childrenDirectories = newChildrenDirectories;
        }
        lastEntry = nextEntry;
        return lastEntry;
    }

    private boolean nameHashIsPresentInChildren(@NotNull DirEntry lastEntry, @NotNull String name, int prevIndex, int nameHash) {
        int[] childrenNameHashes = lastEntry.childrenNameHashes;
        if (childrenNameHashes == null) {
            String[] list = (prevIndex != 0 ? new File(this.myRootDir, name.substring(0, prevIndex)) : this.myRootDir).list();
            if (list != null) {
                childrenNameHashes = new int[list.length];
                for (int i = 0; i < list.length; ++i) {
                    childrenNameHashes[i] = StringUtilRt.stringHashCodeInsensitive((CharSequence)list[i], (int)0, (int)list[i].length());
                }
            } else {
                childrenNameHashes = DirEntry.empty;
            }
            lastEntry.childrenNameHashes = childrenNameHashes;
        }
        for (int childNameHash : childrenNameHashes) {
            if (childNameHash != nameHash) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClasspathCache.LoaderData tryReadFromIndex() {
        if (!this.myConfiguration.myCanHavePersistentIndex) {
            return null;
        }
        long started = System.nanoTime();
        File index = this.getIndexFileFile();
        FilterInputStream reader = null;
        boolean isOk = false;
        try {
            reader = new DataInputStream(new BufferedInputStream(new FileInputStream(index)));
            if (DataInputOutputUtilRt.readINT((DataInput)((Object)reader)) == 1) {
                ClasspathCache.LoaderData loaderData = new ClasspathCache.LoaderData((DataInput)((Object)reader));
                isOk = true;
                ClasspathCache.LoaderData loaderData2 = loaderData;
                return loaderData2;
            }
        }
        catch (FileNotFoundException ex) {
            isOk = true;
        }
        catch (IOException iOException) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (!isOk) {
                index.delete();
            }
            totalReading.addAndGet(System.nanoTime() - started);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trySaveToIndex(@NotNull ClasspathCache.LoaderData data) {
        if (!this.myConfiguration.myCanHavePersistentIndex) {
            return;
        }
        long started = System.nanoTime();
        File index = this.getIndexFileFile();
        UnsyncDataOutputStream writer = null;
        boolean isOk = false;
        try {
            writer = new UnsyncDataOutputStream(new BufferedOutputStream(new FileOutputStream(index)));
            DataInputOutputUtilRt.writeINT((DataOutput)writer, (int)1);
            data.save(writer);
            isOk = true;
        }
        catch (IOException iOException) {
        }
        finally {
            if (writer != null) {
                try {
                    ((OutputStream)writer).close();
                }
                catch (IOException iOException) {}
            }
            if (!isOk) {
                index.delete();
            }
            totalSaving.addAndGet(System.nanoTime() - started);
        }
    }

    @NotNull
    private File getIndexFileFile() {
        return new File(this.myRootDir, "classpath.index");
    }

    @Override
    @NotNull
    public ClasspathCache.LoaderData buildData() {
        long currentScanningTime;
        ClasspathCache.LoaderData loaderData = this.tryReadFromIndex();
        int nsMsFactor = 1000000;
        int currentLoaders = totalLoaders.incrementAndGet();
        if (loaderData == null) {
            long started = System.nanoTime();
            ClasspathCache.LoaderDataBuilder loaderDataBuilder = new ClasspathCache.LoaderDataBuilder();
            this.buildPackageCache(this.myRootDir, loaderDataBuilder);
            loaderData = loaderDataBuilder.build();
            long doneNanos = System.nanoTime() - started;
            currentScanningTime = totalScanning.addAndGet(doneNanos);
            if (doFsActivityLogging.booleanValue()) {
                System.out.println("Scanned: " + this.myRootDirAbsolutePath + " for " + doneNanos / 1000000L + "ms");
            }
            this.trySaveToIndex(loaderData);
        } else {
            currentScanningTime = totalScanning.get();
        }
        if (doFsActivityLogging.booleanValue()) {
            System.out.println("Scanning: " + currentScanningTime / 1000000L + "ms, saving: " + totalSaving.get() / 1000000L + "ms, loading:" + totalReading.get() / 1000000L + "ms for " + currentLoaders + " loaders");
        }
        return loaderData;
    }

    public String toString() {
        return "FileLoader [" + this.myRootDir + "]";
    }

    private static final class UnsyncDataOutputStream
    extends DataOutputStream {
        UnsyncDataOutputStream(@NotNull OutputStream out) {
            super(out);
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }
    }

    private static final class MyResource
    extends Resource {
        private final URL myUrl;
        private final File myFile;

        MyResource(@NotNull URL url, @NotNull File file) {
            this.myUrl = url;
            this.myFile = file;
        }

        @Override
        @NotNull
        public URL getURL() {
            return this.myUrl;
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IOException {
            return new BufferedInputStream(new FileInputStream(this.myFile));
        }

        @Override
        @NotNull
        public byte[] getBytes() throws IOException {
            InputStream stream = this.getInputStream();
            try {
                byte[] byArray = FileUtilRt.loadBytes((InputStream)stream, (int)((int)this.myFile.length()));
                return byArray;
            }
            finally {
                stream.close();
            }
        }
    }

    private static class DirEntry {
        static final int[] empty = new int[0];
        volatile int[] childrenNameHashes;
        volatile DirEntry[] childrenDirectories;
        final int nameHash;
        @NotNull
        final String name;

        DirEntry(int nameHash, @NotNull String name) {
            this.nameHash = nameHash;
            this.name = name;
        }
    }
}

