/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang.java6;

import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.IntObjectHashMap;
import com.intellij.util.lang.java6.BloomFilterBase;
import com.intellij.util.lang.java6.ClassPath;
import com.intellij.util.lang.java6.Loader;
import com.intellij.util.lang.java6.fastutil.StrippedIntOpenHashSet;
import com.intellij.util.lang.java6.fastutil.StrippedLongOpenHashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClasspathCache {
    static final int NUMBER_OF_ACCESSES_FOR_LAZY_CACHING = 1000;
    private static final IntObjectHashMap.ArrayProducer<Object[]> OBJECT_ARRAY_PRODUCER = new IntObjectHashMap.ArrayProducer<Object[]>(){

        public Object[] produce(int s) {
            return s == 0 ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : new Object[s];
        }
    };
    private final IntObjectHashMap<Object> myResourcePackagesCache = new IntObjectHashMap(OBJECT_ARRAY_PRODUCER);
    private final IntObjectHashMap<Object> myClassPackagesCache = new IntObjectHashMap(OBJECT_ARRAY_PRODUCER);
    private static final double PROBABILITY = 0.005;
    private final ReadWriteLock myLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyLoaderData(@NotNull LoaderData loaderData, @NotNull Loader loader) {
        this.myLock.writeLock().lock();
        try {
            for (int resourcePackageHash : loaderData.myResourcePackageHashes) {
                ClasspathCache.addResourceEntry(resourcePackageHash, this.myResourcePackagesCache, loader);
            }
            for (int classPackageHash : loaderData.myClassPackageHashes) {
                ClasspathCache.addResourceEntry(classPackageHash, this.myClassPackagesCache, loader);
            }
            loader.applyData(loaderData);
        }
        finally {
            this.myLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    <R, T1, T2> R iterateLoaders(@NotNull String resourcePath, @NotNull LoaderIterator<R, T1, T2> iterator, @NotNull T1 parameter, @NotNull T2 parameter2, @NotNull String shortName) {
        Loader[] loaders;
        Object o;
        this.myLock.readLock().lock();
        try {
            IntObjectHashMap<Object> map = resourcePath.endsWith(".class") ? this.myClassPackagesCache : this.myResourcePackagesCache;
            o = map.get(ClasspathCache.getPackageNameHash(resourcePath));
        }
        finally {
            this.myLock.readLock().unlock();
        }
        if (o == null) {
            return null;
        }
        if (o instanceof Loader) {
            return iterator.process((Loader)o, parameter, parameter2, shortName);
        }
        for (Loader l : loaders = (Loader[])o) {
            R result = iterator.process(l, parameter, parameter2, shortName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    static int getPackageNameHash(@NotNull String resourcePath) {
        int index = resourcePath.lastIndexOf(47);
        int h = 0;
        for (int off = 0; off < index; ++off) {
            h = 31 * h + resourcePath.charAt(off);
        }
        return h;
    }

    private static void addResourceEntry(int hash, @NotNull IntObjectHashMap map, @NotNull Loader loader) {
        Object o = map.get(hash);
        if (o == null) {
            map.put(hash, (Object)loader);
        } else if (o instanceof Loader) {
            if (ClassPath.recordLoadingInfo) assert (loader != o);
            map.put(hash, (Object)new Loader[]{(Loader)o, loader});
        } else {
            Object[] loadersArray = (Loader[])o;
            if (ClassPath.recordLoadingInfo) assert (ArrayUtilRt.indexOf((Object[])loadersArray, (Object)loader, (int)0, (int)loadersArray.length) == -1);
            Loader[] newArray = Arrays.copyOf(loadersArray, loadersArray.length + 1);
            newArray[loadersArray.length] = loader;
            map.put(hash, (Object)newArray);
        }
    }

    @NotNull
    static String transformName(@NotNull String name) {
        int nameEnd = !name.isEmpty() && name.charAt(name.length() - 1) == '/' ? name.length() - 1 : name.length();
        if ((name = name.substring(name.lastIndexOf(47, nameEnd - 1) + 1, nameEnd)).endsWith(".class")) {
            String name1 = name;
            int $ = name1.indexOf(36);
            if ($ != -1) {
                name1 = name1.substring(0, $);
            } else {
                int index = name1.lastIndexOf(46);
                if (index >= 0) {
                    name1 = name1.substring(0, index);
                }
            }
            name = name1;
        }
        return name;
    }

    static final class NameFilter
    extends BloomFilterBase {
        private static final int SEED = 31;

        NameFilter(int _maxElementCount, double probability) {
            super(_maxElementCount, probability);
        }

        NameFilter(@NotNull DataInput input) throws IOException {
            super(input);
        }

        private void addNameFingerprint(long nameFingerprint) {
            int hash = (int)(nameFingerprint >> 32);
            int hash2 = (int)nameFingerprint;
            this.addIt(hash, hash2);
        }

        boolean maybeContains(@NotNull String name) {
            int hash = name.hashCode();
            int hash2 = StringHash.murmur((CharSequence)name, (int)31);
            return this.maybeContains(hash, hash2);
        }

        @Override
        protected void save(@NotNull DataOutput output) throws IOException {
            super.save(output);
        }

        private static long toNameFingerprint(@NotNull String name) {
            int hash = name.hashCode();
            int hash2 = StringHash.murmur((CharSequence)name, (int)31);
            return (long)hash << 32 | (long)hash2 & 0xFFFFFFFFL;
        }
    }

    static abstract class LoaderIterator<R, T1, T2> {
        LoaderIterator() {
        }

        @Nullable
        abstract R process(@NotNull Loader var1, @NotNull T1 var2, @NotNull T2 var3, @NotNull String var4);
    }

    static final class LoaderDataBuilder {
        private final StrippedLongOpenHashSet myUsedNameFingerprints = new StrippedLongOpenHashSet();
        private final StrippedIntOpenHashSet myResourcePackageHashes = new StrippedIntOpenHashSet();
        private final StrippedIntOpenHashSet myClassPackageHashes = new StrippedIntOpenHashSet();

        LoaderDataBuilder() {
        }

        void addPossiblyDuplicateNameEntry(@NotNull String name) {
            name = ClasspathCache.transformName(name);
            this.myUsedNameFingerprints.add(NameFilter.toNameFingerprint(name));
        }

        void addResourcePackageFromName(@NotNull String path) {
            this.myResourcePackageHashes.add(ClasspathCache.getPackageNameHash(path));
        }

        void addClassPackageFromName(@NotNull String path) {
            this.myClassPackageHashes.add(ClasspathCache.getPackageNameHash(path));
        }

        @NotNull
        LoaderData build() {
            int uniques = this.myUsedNameFingerprints.size();
            if (uniques > 20000) {
                uniques += (int)((double)uniques * 0.03);
            }
            NameFilter nameFilter = new NameFilter(uniques, 0.005);
            StrippedLongOpenHashSet.SetIterator iterator = this.myUsedNameFingerprints.iterator();
            while (iterator.hasNext()) {
                nameFilter.addNameFingerprint(iterator.nextLong());
            }
            return new LoaderData(this.myResourcePackageHashes.toArray(), this.myClassPackageHashes.toArray(), nameFilter);
        }
    }

    static final class LoaderData {
        private final int[] myResourcePackageHashes;
        private final int[] myClassPackageHashes;
        private final NameFilter myNameFilter;

        LoaderData(@NotNull int[] resourcePackageHashes, @NotNull int[] classPackageHashes, @NotNull NameFilter nameFilter) {
            this.myResourcePackageHashes = resourcePackageHashes;
            this.myClassPackageHashes = classPackageHashes;
            this.myNameFilter = nameFilter;
        }

        LoaderData(@NotNull DataInput dataInput) throws IOException {
            this(LoaderData.readIntList(dataInput), LoaderData.readIntList(dataInput), new NameFilter(dataInput));
        }

        @NotNull
        private static int[] readIntList(@NotNull DataInput reader) throws IOException {
            int numberOfElements = DataInputOutputUtilRt.readINT((DataInput)reader);
            int[] ints = new int[numberOfElements];
            for (int i = 0; i < numberOfElements; ++i) {
                ints[i] = DataInputOutputUtilRt.readINT((DataInput)reader);
            }
            return ints;
        }

        void save(@NotNull DataOutput dataOutput) throws IOException {
            LoaderData.writeIntArray(dataOutput, this.myResourcePackageHashes);
            LoaderData.writeIntArray(dataOutput, this.myClassPackageHashes);
            this.myNameFilter.save(dataOutput);
        }

        private static void writeIntArray(@NotNull DataOutput writer, @NotNull int[] hashes) throws IOException {
            DataInputOutputUtilRt.writeINT((DataOutput)writer, (int)hashes.length);
            for (int hash : hashes) {
                DataInputOutputUtilRt.writeINT((DataOutput)writer, (int)hash);
            }
        }

        @NotNull
        NameFilter getNameFilter() {
            return this.myNameFilter;
        }
    }
}

