/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang.java6;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

final class ClassLoadingLocks {
    private final ConcurrentMap<String, WeakLockReference> myMap = new ConcurrentHashMap<String, WeakLockReference>();
    private final ReferenceQueue<Object> myQueue = new ReferenceQueue();

    ClassLoadingLocks() {
    }

    @NotNull
    Object getOrCreateLock(@NotNull String className) {
        WeakLockReference oldRef;
        Object lock;
        WeakLockReference lockReference = (WeakLockReference)this.myMap.get(className);
        if (lockReference != null && (lock = lockReference.get()) != null) {
            return lock;
        }
        Object newLock = new Object();
        WeakLockReference newRef = new WeakLockReference(className, newLock, this.myQueue);
        do {
            this.processQueue();
            oldRef = this.myMap.putIfAbsent(className, newRef);
            if (oldRef == null) {
                return newLock;
            }
            Object oldLock = oldRef.get();
            if (oldLock == null) continue;
            return oldLock;
        } while (!this.myMap.replace(className, oldRef, newRef));
        return newLock;
    }

    private void processQueue() {
        WeakLockReference ref;
        while ((ref = (WeakLockReference)this.myQueue.poll()) != null) {
            this.myMap.remove(ref.myClassName, ref);
        }
    }

    private static final class WeakLockReference
    extends WeakReference<Object> {
        final String myClassName;

        private WeakLockReference(@NotNull String className, @NotNull Object lock, @NotNull ReferenceQueue<Object> q) {
            super(lock, q);
            this.myClassName = className;
        }
    }
}

