/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import java.io.File;
import org.gradle.api.Transformer;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildActionFailureException;
import org.gradle.tooling.internal.consumer.connection.ActionRunner;
import org.gradle.tooling.internal.consumer.connection.InternalBuildActionAdapter;
import org.gradle.tooling.internal.consumer.parameters.BuildCancellationTokenAdapter;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.protocol.BuildParameters;
import org.gradle.tooling.internal.protocol.BuildResult;
import org.gradle.tooling.internal.protocol.InternalBuildActionFailureException;
import org.gradle.tooling.internal.protocol.InternalCancellableConnection;
import org.gradle.tooling.internal.protocol.InternalCancellationToken;

class CancellableActionRunner
implements ActionRunner {
    private final InternalCancellableConnection executor;
    private final Transformer<RuntimeException, RuntimeException> exceptionTransformer;
    private final VersionDetails versionDetails;

    CancellableActionRunner(InternalCancellableConnection executor, Transformer<RuntimeException, RuntimeException> exceptionTransformer, VersionDetails versionDetails) {
        this.executor = executor;
        this.exceptionTransformer = exceptionTransformer;
        this.versionDetails = versionDetails;
    }

    @Override
    public <T> T run(BuildAction<T> action, ConsumerOperationParameters operationParameters) throws UnsupportedOperationException, IllegalStateException {
        BuildResult<T> result2;
        File rootDir = operationParameters.getProjectDir();
        try {
            try {
                result2 = this.execute(new InternalBuildActionAdapter<T>(action, rootDir, this.versionDetails), new BuildCancellationTokenAdapter(operationParameters.getCancellationToken()), operationParameters);
            }
            catch (RuntimeException e) {
                throw this.exceptionTransformer.transform(e);
            }
        }
        catch (InternalBuildActionFailureException e) {
            throw new BuildActionFailureException("The supplied build action failed with an exception.", e.getCause());
        }
        return result2.getModel();
    }

    protected <T> BuildResult<T> execute(InternalBuildActionAdapter<T> buildActionAdapter, InternalCancellationToken cancellationTokenAdapter, BuildParameters operationParameters) {
        return this.executor.run(buildActionAdapter, cancellationTokenAdapter, operationParameters);
    }
}

