/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.streams;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.concurrent.CompositeStoppable;

public class ExecOutputHandleRunner
implements Runnable {
    private static final Logger LOGGER = Logging.getLogger(ExecOutputHandleRunner.class);
    private final String displayName;
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private final int bufferSize;
    private final CountDownLatch completed;
    private volatile boolean closed;

    public ExecOutputHandleRunner(String displayName, InputStream inputStream, OutputStream outputStream, CountDownLatch completed) {
        this(displayName, inputStream, outputStream, 8192, completed);
    }

    ExecOutputHandleRunner(String displayName, InputStream inputStream, OutputStream outputStream, int bufferSize, CountDownLatch completed) {
        this.displayName = displayName;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.bufferSize = bufferSize;
        this.completed = completed;
    }

    @Override
    public void run() {
        try {
            this.forwardContent();
        }
        finally {
            this.completed.countDown();
        }
    }

    private void forwardContent() {
        block3: {
            try {
                int nread;
                byte[] buffer = new byte[this.bufferSize];
                while (!this.closed && (nread = this.inputStream.read(buffer)) >= 0) {
                    this.outputStream.write(buffer, 0, nread);
                    this.outputStream.flush();
                }
                CompositeStoppable.stoppable(this.inputStream, this.outputStream).stop();
            }
            catch (Throwable t) {
                if (this.closed || this.wasInterrupted(t)) break block3;
                LOGGER.error(String.format("Could not %s.", this.displayName), t);
            }
        }
    }

    private boolean wasInterrupted(Throwable t) {
        return t instanceof IOException && "Interrupted system call".equals(t.getMessage());
    }

    public void closeInput() throws IOException {
        this.disconnect();
        this.inputStream.close();
    }

    public String toString() {
        return this.displayName;
    }

    public void disconnect() {
        this.closed = true;
    }
}

