/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.dependents;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.collect.LinkedListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.dependents.DefaultDependentBinariesResolutionResult;
import org.gradle.platform.base.internal.dependents.DefaultDependentBinariesResolvedResult;
import org.gradle.platform.base.internal.dependents.DependentBinariesResolutionResult;
import org.gradle.platform.base.internal.dependents.DependentBinariesResolutionStrategy;
import org.gradle.platform.base.internal.dependents.DependentBinariesResolvedResult;
import org.gradle.platform.base.internal.dependents.DependentBinariesResolver;

public class DefaultDependentBinariesResolver
implements DependentBinariesResolver {
    private final Map<String, DependentBinariesResolutionStrategy> strategies = Maps.newLinkedHashMap();

    @Override
    public void register(DependentBinariesResolutionStrategy strategy) {
        Preconditions.checkNotNull((Object)strategy, (Object)"strategy must not be null");
        this.strategies.put(strategy.getName(), strategy);
    }

    @Override
    public <T extends DependentBinariesResolutionStrategy> T getStrategy(String name, Class<T> type) {
        return (T)((DependentBinariesResolutionStrategy)Cast.castNullable(type, this.strategies.get(name)));
    }

    @Override
    public DependentBinariesResolutionResult resolve(BinarySpecInternal target) {
        ArrayList roots = Lists.newArrayList();
        for (DependentBinariesResolutionStrategy strategy : this.strategies.values()) {
            DependentBinariesResolutionResult result2 = strategy.resolve(target);
            roots.add(result2.getRoot());
        }
        return new DefaultDependentBinariesResolutionResult(this.mergeResults(roots));
    }

    private DependentBinariesResolvedResult mergeResults(Collection<DependentBinariesResolvedResult> results) {
        DependentBinariesResolvedResult first = results.iterator().next();
        if (results.size() == 1) {
            return first;
        }
        boolean hasNotBuildables = false;
        boolean hasTestSuites = false;
        LinkedListMultimap index = LinkedListMultimap.create();
        ArrayList allChildren = Lists.newArrayList();
        for (DependentBinariesResolvedResult result2 : results) {
            if (!result2.isBuildable()) {
                hasNotBuildables = true;
            }
            if (result2.isTestSuite()) {
                hasTestSuites = true;
            }
            allChildren.addAll(result2.getChildren());
            for (DependentBinariesResolvedResult child : result2.getChildren()) {
                index.put((Object)child.getId(), (Object)child);
            }
        }
        ArrayList children = Lists.newArrayList();
        for (Collection childResults : index.asMap().values()) {
            children.add(this.mergeResults(childResults));
        }
        return new DefaultDependentBinariesResolvedResult(first.getId(), first.getProjectScopedName(), !hasNotBuildables, hasTestSuites, children);
    }
}

