/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.xctest.plugins;

import java.io.File;
import java.util.Arrays;
import javax.inject.Inject;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.internal.NativeComponentFactory;
import org.gradle.language.nativeplatform.internal.Dimensions;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.language.nativeplatform.tasks.UnexportMainSymbol;
import org.gradle.language.swift.ProductionSwiftComponent;
import org.gradle.language.swift.SwiftApplication;
import org.gradle.language.swift.SwiftComponent;
import org.gradle.language.swift.SwiftPlatform;
import org.gradle.language.swift.SwiftVersion;
import org.gradle.language.swift.internal.DefaultSwiftBinary;
import org.gradle.language.swift.internal.DefaultSwiftPlatform;
import org.gradle.language.swift.plugins.SwiftBasePlugin;
import org.gradle.language.swift.tasks.SwiftCompile;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.nativeplatform.TargetMachine;
import org.gradle.nativeplatform.TargetMachineFactory;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.tasks.LinkMachOBundle;
import org.gradle.nativeplatform.test.plugins.NativeTestingBasePlugin;
import org.gradle.nativeplatform.test.xctest.SwiftXCTestBinary;
import org.gradle.nativeplatform.test.xctest.SwiftXCTestBundle;
import org.gradle.nativeplatform.test.xctest.SwiftXCTestSuite;
import org.gradle.nativeplatform.test.xctest.internal.DefaultSwiftXCTestBinary;
import org.gradle.nativeplatform.test.xctest.internal.DefaultSwiftXCTestBundle;
import org.gradle.nativeplatform.test.xctest.internal.DefaultSwiftXCTestExecutable;
import org.gradle.nativeplatform.test.xctest.internal.DefaultSwiftXCTestSuite;
import org.gradle.nativeplatform.test.xctest.tasks.InstallXCTestBundle;
import org.gradle.nativeplatform.test.xctest.tasks.XCTest;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainRegistryInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.nativeplatform.toolchain.internal.xcode.MacOSSdkPlatformPathLocator;
import org.gradle.util.internal.GUtil;

public class XCTestConventionPlugin
implements Plugin<Project> {
    private final MacOSSdkPlatformPathLocator sdkPlatformPathLocator;
    private final ToolChainSelector toolChainSelector;
    private final NativeComponentFactory componentFactory;
    private final ObjectFactory objectFactory;
    private final ImmutableAttributesFactory attributesFactory;
    private final TargetMachineFactory targetMachineFactory;

    @Inject
    public XCTestConventionPlugin(MacOSSdkPlatformPathLocator sdkPlatformPathLocator, ToolChainSelector toolChainSelector, NativeComponentFactory componentFactory, ObjectFactory objectFactory, ImmutableAttributesFactory attributesFactory, TargetMachineFactory targetMachineFactory) {
        this.sdkPlatformPathLocator = sdkPlatformPathLocator;
        this.toolChainSelector = toolChainSelector;
        this.componentFactory = componentFactory;
        this.objectFactory = objectFactory;
        this.attributesFactory = attributesFactory;
        this.targetMachineFactory = targetMachineFactory;
    }

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(SwiftBasePlugin.class);
        project.getPluginManager().apply(NativeTestingBasePlugin.class);
        ProviderFactory providers = project.getProviders();
        DefaultSwiftXCTestSuite testSuite = this.componentFactory.newInstance(SwiftXCTestSuite.class, DefaultSwiftXCTestSuite.class, "test");
        project.getExtensions().add(SwiftXCTestSuite.class, "xctest", testSuite);
        project.getComponents().add(testSuite);
        testSuite.getModule().set(GUtil.toCamelCase(project.getName() + "Test"));
        DefaultSwiftXCTestSuite testComponent = testSuite;
        testComponent.getTargetMachines().convention(Dimensions.useHostAsDefaultTargetMachine(this.targetMachineFactory));
        testComponent.getSourceCompatibility().convention(testComponent.getTestedComponent().flatMap(it -> it.getSourceCompatibility()));
        String mainComponentName = "main";
        project.getComponents().withType(ProductionSwiftComponent.class, component -> {
            if ("main".equals(component.getName())) {
                testComponent.getTargetMachines().convention(component.getTargetMachines());
                testComponent.getTestedComponent().convention((SwiftComponent)component);
            }
        });
        testComponent.getTestBinary().convention(project.provider(() -> ((DefaultBinaryCollection)testComponent.getBinaries()).get().stream().filter(SwiftXCTestBinary.class::isInstance).map(SwiftXCTestBinary.class::cast).findFirst().orElse(null)));
        ((DefaultBinaryCollection)testComponent.getBinaries()).whenElementKnown(DefaultSwiftXCTestBinary.class, binary -> {
            NamedDomainObjectProvider testingTask = project.getTasks().register("xcTest", XCTest.class, task -> {
                task.setGroup("verification");
                task.setDescription("Executes XCTest suites");
                task.getTestInstallDirectory().set(binary.getInstallDirectory());
                task.getRunScriptFile().set(binary.getRunScriptFile());
                task.getWorkingDirectory().set(binary.getInstallDirectory());
            });
            binary.getRunTask().set(testingTask);
            this.configureTestSuiteBuildingTasks(project, (DefaultSwiftXCTestBinary)binary);
            this.configureTestSuiteWithTestedComponentWhenAvailable(project, testComponent, (DefaultSwiftXCTestBinary)binary);
        });
        project.afterEvaluate(p -> {
            SwiftComponent mainComponent = (SwiftComponent)testComponent.getTestedComponent().getOrNull();
            SetProperty<TargetMachine> mainTargetMachines = mainComponent != null ? mainComponent.getTargetMachines() : null;
            Dimensions.unitTestVariants(testComponent.getModule(), testComponent.getTargetMachines(), mainTargetMachines, this.objectFactory, this.attributesFactory, providers.provider(() -> project.getGroup().toString()), providers.provider(() -> project.getVersion().toString()), variantIdentity -> {
                if (Dimensions.tryToBuildOnHost(variantIdentity)) {
                    testComponent.getSourceCompatibility().finalizeValue();
                    ToolChainSelector.Result<DefaultSwiftPlatform> result2 = this.toolChainSelector.select(SwiftPlatform.class, new DefaultSwiftPlatform(variantIdentity.getTargetMachine(), (SwiftVersion)((Object)((Object)((Object)testComponent.getSourceCompatibility().getOrNull())))));
                    if (((SwiftPlatform)result2.getTargetPlatform()).getTargetMachine().getOperatingSystemFamily().isMacOs()) {
                        testComponent.addBundle((NativeVariantIdentity)variantIdentity, result2.getTargetPlatform(), result2.getToolChain(), result2.getPlatformToolProvider());
                    } else {
                        testComponent.addExecutable((NativeVariantIdentity)variantIdentity, result2.getTargetPlatform(), result2.getToolChain(), result2.getPlatformToolProvider());
                    }
                }
            });
            ((DefaultBinaryCollection)testComponent.getBinaries()).realizeNow();
        });
    }

    private void configureTestSuiteBuildingTasks(Project project, DefaultSwiftXCTestBinary binary) {
        SwiftCompile compile = (SwiftCompile)binary.getCompileTask().get();
        compile.getSource().setFrom(binary.getSwiftSource().getAsFileTree().matching(patterns -> patterns.include("**/*").exclude("**/LinuxMain.swift")));
        if (binary instanceof SwiftXCTestBundle) {
            TaskContainer tasks = project.getTasks();
            Names names = binary.getNames();
            DefaultNativePlatform currentPlatform = new DefaultNativePlatform("current");
            ModelRegistry modelRegistry = ((ProjectInternal)project).getModelRegistry();
            NativeToolChain toolChain = (NativeToolChain)modelRegistry.realize("toolChains", NativeToolChainRegistryInternal.class).getForPlatform(currentPlatform);
            compile.getCompilerArgs().addAll(project.provider(() -> {
                File platformSdkPath = this.sdkPlatformPathLocator.find();
                File frameworkDir = new File(platformSdkPath, "Developer/Library/Frameworks");
                File extraInclude = new File(platformSdkPath, "Developer/usr/lib");
                return Arrays.asList("-parse-as-library", "-F" + frameworkDir.getAbsolutePath(), "-I", extraInclude.getAbsolutePath(), "-v");
            }));
            NamedDomainObjectProvider link = tasks.register(names.getTaskName("link"), LinkMachOBundle.class, task -> {
                task.getLinkerArgs().set(project.provider(() -> {
                    File platformSdkPath = this.sdkPlatformPathLocator.find();
                    File frameworkDir = new File(platformSdkPath, "Developer/Library/Frameworks");
                    File extraInclude = new File(platformSdkPath, "Developer/usr/lib");
                    return Lists.newArrayList((Object[])new String[]{"-F" + frameworkDir.getAbsolutePath(), "-L", extraInclude.getAbsolutePath(), "-framework", "XCTest", "-Xlinker", "-rpath", "-Xlinker", "@executable_path/../Frameworks", "-Xlinker", "-rpath", "-Xlinker", "@loader_path/../Frameworks"});
                }));
                task.source(binary.getObjects());
                task.lib(binary.getLinkLibraries());
                PlatformToolProvider toolProvider = ((NativeToolChainInternal)toolChain).select(currentPlatform);
                Provider<RegularFile> exeLocation = project.getLayout().getBuildDirectory().file(binary.getBaseName().map(baseName -> toolProvider.getExecutableName("exe/" + names.getDirName() + baseName)));
                task.getLinkedFile().set(exeLocation);
                task.getTargetPlatform().set(currentPlatform);
                task.getToolChain().set(toolChain);
                task.getDebuggable().set(binary.isDebuggable());
            });
            NamedDomainObjectProvider install = tasks.register(names.getTaskName("install"), InstallXCTestBundle.class, arg_0 -> XCTestConventionPlugin.lambda$configureTestSuiteBuildingTasks$14((TaskProvider)link, project, names, arg_0));
            binary.getInstallDirectory().set(install.flatMap(task -> task.getInstallDirectory()));
            binary.getExecutableFile().set(link.flatMap(task -> task.getLinkedFile()));
            DefaultSwiftXCTestBundle bundle = (DefaultSwiftXCTestBundle)binary;
            bundle.getLinkTask().set(link);
            bundle.getRunScriptFile().set(install.flatMap(task -> task.getRunScriptFile()));
        } else {
            DefaultSwiftXCTestExecutable executable = (DefaultSwiftXCTestExecutable)binary;
            executable.getRunScriptFile().set(executable.getInstallTask().flatMap(task -> task.getRunScriptFile()));
            if (binary.getTargetMachine().getOperatingSystemFamily().isLinux()) {
                NamedDomainObjectProvider renameLinuxMainTask = project.getTasks().register("renameLinuxMain", Sync.class, task -> {
                    task.from(binary.getSwiftSource());
                    task.into(project.provider(() -> task.getTemporaryDir()));
                    task.include("LinuxMain.swift");
                    task.rename(it -> "main.swift");
                });
                compile.getSource().from(project.files(renameLinuxMainTask).getAsFileTree().matching(patterns -> patterns.include("**/*.swift")));
            }
        }
    }

    private void configureTestSuiteWithTestedComponentWhenAvailable(Project project, DefaultSwiftXCTestSuite testSuite, DefaultSwiftXCTestBinary testExecutable) {
        SwiftComponent target = (SwiftComponent)testSuite.getTestedComponent().getOrNull();
        if (!(target instanceof ProductionSwiftComponent)) {
            return;
        }
        ProductionSwiftComponent testedComponent = (ProductionSwiftComponent)target;
        TaskContainer tasks = project.getTasks();
        testedComponent.getBinaries().whenElementFinalized(testedBinary -> {
            if (testedBinary != testedComponent.getDevelopmentBinary().get()) {
                return;
            }
            testExecutable.getImplementationDependencies().extendsFrom(((DefaultSwiftBinary)testedBinary).getImplementationDependencies());
            Dependency compileDependency = project.getDependencies().create(project.files(testedBinary.getModuleFile()));
            testExecutable.getImportPathConfiguration().getDependencies().add(compileDependency);
            ConfigurableFileCollection testableObjects = project.files(new Object[0]);
            if (testedComponent instanceof SwiftApplication) {
                NamedDomainObjectProvider unexportMainSymbol = tasks.register("relocateMainForTest", UnexportMainSymbol.class, task -> {
                    String dirName = ((DefaultSwiftBinary)testedBinary).getNames().getDirName();
                    task.getOutputDirectory().set(project.getLayout().getBuildDirectory().dir("obj/for-test/" + dirName));
                    task.getObjects().from(testedBinary.getObjects());
                });
                testableObjects.from(unexportMainSymbol.map(task -> task.getRelocatedObjects()));
            } else {
                testableObjects.from(testedBinary.getObjects());
            }
            Dependency linkDependency = project.getDependencies().create(testableObjects);
            testExecutable.getLinkConfiguration().getDependencies().add(linkDependency);
        });
    }

    private static /* synthetic */ void lambda$configureTestSuiteBuildingTasks$14(TaskProvider link, Project project, Names names, InstallXCTestBundle task) {
        task.getBundleBinaryFile().set(((LinkMachOBundle)link.get()).getLinkedFile());
        task.getInstallDirectory().set(project.getLayout().getBuildDirectory().dir("install/" + names.getDirName()));
    }
}

