/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.remote.internal.hub.queue;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.gradle.internal.remote.internal.hub.protocol.ChannelIdentifier;
import org.gradle.internal.remote.internal.hub.protocol.InterHubMessage;
import org.gradle.internal.remote.internal.hub.protocol.Routable;
import org.gradle.internal.remote.internal.hub.queue.MultiEndPointQueue;
import org.gradle.internal.remote.internal.hub.queue.QueueInitializer;

public class MultiChannelQueue {
    private final Lock lock;
    private final Map<ChannelIdentifier, MultiEndPointQueue> channels = new HashMap<ChannelIdentifier, MultiEndPointQueue>();
    private final QueueInitializer initializer = new QueueInitializer();

    public MultiChannelQueue(Lock lock) {
        this.lock = lock;
    }

    public MultiEndPointQueue getChannel(ChannelIdentifier channel) {
        MultiEndPointQueue queue = this.channels.get(channel);
        if (queue == null) {
            queue = new MultiEndPointQueue(this.lock);
            this.channels.put(channel, queue);
            this.initializer.onQueueAdded(queue);
        }
        return queue;
    }

    public void queue(InterHubMessage message2) {
        if (message2.getDelivery() == InterHubMessage.Delivery.Stateful) {
            this.initializer.onStatefulMessage(message2);
        }
        if (message2 instanceof Routable) {
            Routable routableMessage = (Routable)((Object)message2);
            this.getChannel(routableMessage.getChannel()).dispatch(message2);
        } else if (message2.getDelivery() == InterHubMessage.Delivery.Stateful || message2.getDelivery() == InterHubMessage.Delivery.AllHandlers) {
            for (MultiEndPointQueue queue : this.channels.values()) {
                queue.dispatch(message2);
            }
        } else {
            throw new IllegalArgumentException(String.format("Don't know how to route message %s.", message2));
        }
    }
}

