/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.remote.internal.hub;

import java.util.ArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.Action;
import org.gradle.internal.Cast;
import org.gradle.internal.concurrent.AsyncStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.dispatch.BoundedDispatch;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.remote.internal.Connection;
import org.gradle.internal.remote.internal.RecoverableMessageIOException;
import org.gradle.internal.remote.internal.RemoteConnection;
import org.gradle.internal.remote.internal.hub.ConnectionSet;
import org.gradle.internal.remote.internal.hub.ConnectionState;
import org.gradle.internal.remote.internal.hub.IncomingQueue;
import org.gradle.internal.remote.internal.hub.OutgoingQueue;
import org.gradle.internal.remote.internal.hub.RejectedMessageListener;
import org.gradle.internal.remote.internal.hub.StreamFailureHandler;
import org.gradle.internal.remote.internal.hub.protocol.ChannelIdentifier;
import org.gradle.internal.remote.internal.hub.protocol.ChannelMessage;
import org.gradle.internal.remote.internal.hub.protocol.EndOfStream;
import org.gradle.internal.remote.internal.hub.protocol.InterHubMessage;
import org.gradle.internal.remote.internal.hub.protocol.RejectedMessage;
import org.gradle.internal.remote.internal.hub.protocol.StreamFailureMessage;
import org.gradle.internal.remote.internal.hub.queue.EndPointQueue;

public class MessageHub
implements AsyncStoppable {
    private static final Discard DISCARD = new Discard();
    private final ManagedExecutor workers;
    private final String displayName;
    private final Action<? super Throwable> errorHandler;
    private final Lock lock = new ReentrantLock();
    private State state = State.Running;
    private final IncomingQueue incomingQueue = new IncomingQueue(this.lock);
    private final OutgoingQueue outgoingQueue = new OutgoingQueue(this.incomingQueue, this.lock);
    private final ConnectionSet connections = new ConnectionSet(this.incomingQueue, this.outgoingQueue);

    public MessageHub(String displayName, ExecutorFactory executorFactory, Action<? super Throwable> errorHandler) {
        this.displayName = displayName;
        this.errorHandler = errorHandler;
        this.workers = executorFactory.create(displayName + " workers");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Dispatch<T> getOutgoing(String channelName, Class<T> type) {
        this.lock.lock();
        try {
            this.assertRunning("create outgoing dispatch");
            ChannelDispatch<T> channelDispatch = new ChannelDispatch<T>(type, new ChannelIdentifier(channelName));
            return channelDispatch;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(String channelName, Object handler) {
        this.lock.lock();
        try {
            this.assertRunning("add handler");
            RejectedMessageListener rejectedMessageListener = handler instanceof RejectedMessageListener ? (RejectedMessageListener)handler : DISCARD;
            Dispatch<Object> dispatch = handler instanceof Dispatch ? (Dispatch)Cast.uncheckedNonnullCast(handler) : DISCARD;
            BoundedDispatch<Object> boundedDispatch = dispatch instanceof BoundedDispatch ? (BoundedDispatch)Cast.uncheckedNonnullCast(dispatch) : DISCARD;
            StreamFailureHandler streamFailureHandler = handler instanceof StreamFailureHandler ? (StreamFailureHandler)handler : DISCARD;
            ChannelIdentifier identifier = new ChannelIdentifier(channelName);
            EndPointQueue queue = this.incomingQueue.getChannel(identifier).newEndpoint();
            this.workers.execute(new Handler(queue, dispatch, boundedDispatch, rejectedMessageListener, streamFailureHandler));
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addConnection(RemoteConnection<InterHubMessage> connection) {
        this.lock.lock();
        try {
            this.assertRunning("add connection");
            ConnectionState connectionState = this.connections.add(connection);
            this.workers.execute(new ConnectionDispatch(connectionState));
            this.workers.execute(new ConnectionReceive(connectionState));
        }
        finally {
            this.lock.unlock();
        }
    }

    public void noFurtherConnections() {
        this.lock.lock();
        try {
            this.connections.noFurtherConnections();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void assertRunning(String action) {
        if (this.state != State.Running) {
            throw new IllegalStateException(String.format("Cannot %s, as %s has been stopped.", action, this.displayName));
        }
    }

    @Override
    public void requestStop() {
        this.lock.lock();
        try {
            if (this.state != State.Running) {
                return;
            }
            try {
                this.outgoingQueue.endOutput();
                this.connections.noFurtherConnections();
            }
            finally {
                this.state = State.Stopping;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            this.lock.lock();
            try {
                this.requestStop();
            }
            finally {
                this.lock.unlock();
            }
            this.workers.stop();
        }
        finally {
            this.lock.lock();
            try {
                this.state = State.Stopped;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void addToIncoming(InterHubMessage message2) {
        this.lock.lock();
        try {
            this.incomingQueue.queue(message2);
        }
        finally {
            this.lock.unlock();
        }
    }

    private class Handler
    implements Runnable {
        private final EndPointQueue queue;
        private final Dispatch<Object> dispatch;
        private final BoundedDispatch<Object> boundedDispatch;
        private final RejectedMessageListener listener;
        private final StreamFailureHandler streamFailureHandler;

        public Handler(EndPointQueue queue, Dispatch<Object> dispatch, BoundedDispatch<Object> boundedDispatch, RejectedMessageListener listener2, StreamFailureHandler streamFailureHandler) {
            this.queue = queue;
            this.dispatch = dispatch;
            this.boundedDispatch = boundedDispatch;
            this.listener = listener2;
            this.streamFailureHandler = streamFailureHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ArrayList<InterHubMessage> messages = new ArrayList<InterHubMessage>();
                try {
                    while (true) {
                        MessageHub.this.lock.lock();
                        try {
                            this.queue.take(messages);
                        }
                        finally {
                            MessageHub.this.lock.unlock();
                        }
                        for (InterHubMessage message2 : messages) {
                            if (message2 instanceof EndOfStream) {
                                this.boundedDispatch.endStream();
                                return;
                            }
                            if (message2 instanceof ChannelMessage) {
                                ChannelMessage channelMessage = (ChannelMessage)message2;
                                this.dispatch.dispatch(channelMessage.getPayload());
                                continue;
                            }
                            if (message2 instanceof RejectedMessage) {
                                RejectedMessage rejectedMessage = (RejectedMessage)message2;
                                this.listener.messageDiscarded(rejectedMessage.getPayload());
                                continue;
                            }
                            if (message2 instanceof StreamFailureMessage) {
                                StreamFailureMessage streamFailureMessage = (StreamFailureMessage)message2;
                                this.streamFailureHandler.handleStreamFailure(streamFailureMessage.getFailure());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("Don't know how to handle message %s", message2));
                        }
                        messages.clear();
                    }
                }
                finally {
                    MessageHub.this.lock.lock();
                    try {
                        this.queue.stop();
                    }
                    finally {
                        MessageHub.this.lock.unlock();
                    }
                }
            }
            catch (Throwable t) {
                MessageHub.this.errorHandler.execute(t);
                return;
            }
        }
    }

    private class ChannelDispatch<T>
    implements Dispatch<T> {
        private final Class<T> type;
        private final ChannelIdentifier channelIdentifier;

        public ChannelDispatch(Class<T> type, ChannelIdentifier channelIdentifier) {
            this.type = type;
            this.channelIdentifier = channelIdentifier;
        }

        public String toString() {
            return "Dispatch " + this.type.getSimpleName() + " to " + MessageHub.this.displayName + " channel " + this.channelIdentifier;
        }

        @Override
        public void dispatch(T message2) {
            MessageHub.this.lock.lock();
            try {
                MessageHub.this.assertRunning("dispatch message");
                MessageHub.this.outgoingQueue.dispatch(new ChannelMessage(this.channelIdentifier, message2));
            }
            finally {
                MessageHub.this.lock.unlock();
            }
        }
    }

    private class ConnectionDispatch
    implements Runnable {
        private final RemoteConnection<InterHubMessage> connection;
        private final EndPointQueue queue;
        private final ConnectionState connectionState;

        private ConnectionDispatch(ConnectionState connectionState) {
            this.connection = connectionState.getConnection();
            this.queue = connectionState.getDispatchQueue();
            this.connectionState = connectionState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ArrayList<InterHubMessage> messages = new ArrayList<InterHubMessage>();
                try {
                    while (true) {
                        MessageHub.this.lock.lock();
                        try {
                            this.queue.take(messages);
                        }
                        finally {
                            MessageHub.this.lock.unlock();
                        }
                        for (InterHubMessage message2 : messages) {
                            try {
                                this.connection.dispatch(message2);
                            }
                            catch (RecoverableMessageIOException e) {
                                MessageHub.this.addToIncoming(new StreamFailureMessage(e));
                            }
                            if (!(message2 instanceof EndOfStream)) continue;
                            this.connection.flush();
                            return;
                        }
                        this.connection.flush();
                        messages.clear();
                    }
                }
                finally {
                    MessageHub.this.lock.lock();
                    try {
                        this.connectionState.dispatchFinished();
                    }
                    finally {
                        MessageHub.this.lock.unlock();
                    }
                }
            }
            catch (Throwable t) {
                MessageHub.this.errorHandler.execute(t);
                return;
            }
        }
    }

    private class ConnectionReceive
    implements Runnable {
        private final Connection<InterHubMessage> connection;
        private final ConnectionState connectionState;

        public ConnectionReceive(ConnectionState connectionState) {
            this.connection = connectionState.getConnection();
            this.connectionState = connectionState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    while (true) {
                        InterHubMessage message2;
                        try {
                            message2 = (InterHubMessage)this.connection.receive();
                        }
                        catch (RecoverableMessageIOException e) {
                            MessageHub.this.addToIncoming(new StreamFailureMessage(e));
                            continue;
                        }
                        if (message2 == null || message2 instanceof EndOfStream) {
                            return;
                        }
                        MessageHub.this.addToIncoming(message2);
                    }
                }
                finally {
                    MessageHub.this.lock.lock();
                    try {
                        this.connectionState.receiveFinished();
                    }
                    finally {
                        MessageHub.this.lock.unlock();
                    }
                }
            }
            catch (Throwable e) {
                MessageHub.this.errorHandler.execute(e);
                return;
            }
        }
    }

    private static class Discard
    implements BoundedDispatch<Object>,
    RejectedMessageListener,
    StreamFailureHandler {
        private Discard() {
        }

        @Override
        public void dispatch(Object message2) {
        }

        @Override
        public void endStream() {
        }

        @Override
        public void messageDiscarded(Object message2) {
        }

        @Override
        public void handleStreamFailure(Throwable t) {
        }
    }

    private static enum State {
        Running,
        Stopping,
        Stopped;

    }
}

