/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.lazy;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.internal.lazy.Lazy;

@ThreadSafe
class SynchronizedLazy<T>
implements Lazy<T> {
    private final Object lock = new Object();
    private Supplier<T> supplier;
    private volatile T value;

    public SynchronizedLazy(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    @Override
    public T get() {
        return this.ensureValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T ensureValue() {
        if (this.supplier != null) {
            Object object = this.lock;
            synchronized (object) {
                this.maybeInitialize();
            }
        }
        return this.value;
    }

    private void maybeInitialize() {
        if (this.supplier != null) {
            this.value = this.supplier.get();
            this.supplier = null;
        }
    }

    @Override
    public void use(Consumer<? super T> consumer) {
    }

    @Override
    public <V> V apply(Function<? super T, V> function) {
        return function.apply(this.ensureValue());
    }
}

