/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.java.archives.internal;

import groovy.lang.Closure;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.java.archives.Attributes;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.java.archives.ManifestMergeDetails;
import org.gradle.api.java.archives.ManifestMergeSpec;
import org.gradle.api.java.archives.internal.DefaultAttributes;
import org.gradle.api.java.archives.internal.DefaultManifest;
import org.gradle.api.java.archives.internal.DefaultManifestMergeDetails;
import org.gradle.api.java.archives.internal.ManifestInternal;
import org.gradle.api.provider.Provider;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.util.internal.ConfigureUtil;
import org.gradle.util.internal.GUtil;
import org.gradle.util.internal.WrapUtil;

public class DefaultManifestMergeSpec
implements ManifestMergeSpec {
    List<Object> mergePaths = new ArrayList<Object>();
    private final List<Action<? super ManifestMergeDetails>> actions = new ArrayList<Action<? super ManifestMergeDetails>>();
    private String contentCharset = "UTF-8";

    @Override
    public String getContentCharset() {
        return this.contentCharset;
    }

    @Override
    public void setContentCharset(String contentCharset) {
        if (contentCharset == null) {
            throw new InvalidUserDataException("contentCharset must not be null");
        }
        if (!Charset.isSupported(contentCharset)) {
            throw new InvalidUserDataException(String.format("Charset for contentCharset '%s' is not supported by your JVM", contentCharset));
        }
        this.contentCharset = contentCharset;
    }

    @Override
    public ManifestMergeSpec from(Object ... mergePaths) {
        GUtil.flatten(mergePaths, this.mergePaths);
        return this;
    }

    @Override
    public ManifestMergeSpec eachEntry(Action<? super ManifestMergeDetails> mergeAction) {
        this.actions.add(mergeAction);
        return this;
    }

    @Override
    public ManifestMergeSpec eachEntry(Closure<?> mergeAction) {
        return this.eachEntry(ConfigureUtil.configureUsing(mergeAction));
    }

    public DefaultManifest merge(Manifest baseManifest, PathToFileResolver fileResolver) {
        String baseContentCharset = baseManifest instanceof ManifestInternal ? ((ManifestInternal)baseManifest).getContentCharset() : "UTF-8";
        DefaultManifest mergedManifest = new DefaultManifest(fileResolver, baseContentCharset);
        mergedManifest.getAttributes().putAll(baseManifest.getAttributes());
        mergedManifest.getSections().putAll(baseManifest.getSections());
        for (Object mergePath : this.mergePaths) {
            DefaultManifest manifestToMerge = this.createManifest(mergePath, fileResolver, this.contentCharset);
            mergedManifest = this.mergeManifest(mergedManifest, manifestToMerge, fileResolver);
        }
        return mergedManifest;
    }

    private DefaultManifest mergeManifest(DefaultManifest baseManifest, DefaultManifest toMergeManifest, PathToFileResolver fileResolver) {
        DefaultManifest mergedManifest = new DefaultManifest(fileResolver);
        this.mergeSection(null, mergedManifest, baseManifest.getAttributes(), toMergeManifest.getAttributes());
        Sets.SetView allSections = Sets.union(baseManifest.getSections().keySet(), toMergeManifest.getSections().keySet());
        for (String section : allSections) {
            this.mergeSection(section, mergedManifest, GUtil.getOrDefault(baseManifest.getSections().get(section), DefaultAttributes::new), GUtil.getOrDefault(toMergeManifest.getSections().get(section), DefaultAttributes::new));
        }
        return mergedManifest;
    }

    private void mergeSection(String section, DefaultManifest mergedManifest, Attributes baseAttributes, Attributes mergeAttributes) {
        LinkedHashMap<String, Object> mergeOnlyAttributes = new LinkedHashMap<String, Object>(mergeAttributes);
        LinkedHashSet<DefaultManifestMergeDetails> mergeDetailsSet = new LinkedHashSet<DefaultManifestMergeDetails>();
        for (Map.Entry baseEntry : baseAttributes.entrySet()) {
            Object mergeValue = mergeAttributes.get(baseEntry.getKey());
            mergeDetailsSet.add(this.getMergeDetails(section, (String)baseEntry.getKey(), baseEntry.getValue(), mergeValue));
            mergeOnlyAttributes.remove(baseEntry.getKey());
        }
        for (Map.Entry mergeEntry : mergeOnlyAttributes.entrySet()) {
            mergeDetailsSet.add(this.getMergeDetails(section, (String)mergeEntry.getKey(), null, mergeEntry.getValue()));
        }
        for (DefaultManifestMergeDetails mergeDetails : mergeDetailsSet) {
            for (Action<? super ManifestMergeDetails> action : this.actions) {
                action.execute(mergeDetails);
            }
            this.addMergeDetailToManifest(section, mergedManifest, mergeDetails);
        }
    }

    private DefaultManifestMergeDetails getMergeDetails(String section, String key, Object baseValue, Object mergeValue) {
        String baseValueString = DefaultManifestMergeSpec.resolveValueToString(baseValue);
        String mergeValueString = DefaultManifestMergeSpec.resolveValueToString(mergeValue);
        String value = mergeValueString == null ? baseValueString : mergeValueString;
        return new DefaultManifestMergeDetails(section, key, baseValueString, mergeValueString, value);
    }

    private static String resolveValueToString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Provider) {
            Object providedValue = ((Provider)value).getOrNull();
            return DefaultManifestMergeSpec.resolveValueToString(providedValue);
        }
        return value.toString();
    }

    private void addMergeDetailToManifest(String section, DefaultManifest mergedManifest, DefaultManifestMergeDetails mergeDetails) {
        if (!mergeDetails.isExcluded()) {
            if (section == null) {
                mergedManifest.attributes((Map)WrapUtil.toMap(mergeDetails.getKey(), mergeDetails.getValue()));
            } else {
                mergedManifest.attributes((Map)WrapUtil.toMap(mergeDetails.getKey(), mergeDetails.getValue()), section);
            }
        }
    }

    private DefaultManifest createManifest(Object mergePath, PathToFileResolver fileResolver, String contentCharset) {
        if (mergePath instanceof DefaultManifest) {
            return ((DefaultManifest)mergePath).getEffectiveManifest();
        }
        return new DefaultManifest(mergePath, fileResolver, contentCharset);
    }

    public List<Object> getMergePaths() {
        return this.mergePaths;
    }
}

