/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.scala;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.tasks.scala.MinimalScalaCompileOptions;
import org.gradle.api.internal.tasks.scala.ScalaCompileSpec;
import org.gradle.internal.impldep.com.google.common.collect.Lists;

public class ZincScalaCompilerArgumentsGenerator {
    public List<String> generate(ScalaCompileSpec spec) {
        ArrayList result2 = Lists.newArrayList();
        MinimalScalaCompileOptions options = spec.getScalaCompileOptions();
        this.addFlag("-deprecation", options.isDeprecation(), result2);
        this.addFlag("-unchecked", options.isUnchecked(), result2);
        this.addConcatenatedOption("-g:", options.getDebugLevel(), result2);
        this.addFlag("-optimise", options.isOptimize(), result2);
        this.addOption("-encoding", options.getEncoding(), result2);
        this.addFlag("-verbose", "verbose".equals(options.getDebugLevel()), result2);
        this.addFlag("-Ydebug", "debug".equals(options.getDebugLevel()), result2);
        if (options.getLoggingPhases() != null) {
            for (String phase : options.getLoggingPhases()) {
                this.addConcatenatedOption("-Ylog:", phase, result2);
            }
        }
        if (options.getAdditionalParameters() != null) {
            result2.addAll(options.getAdditionalParameters());
        }
        if (spec.getScalaCompilerPlugins() != null) {
            for (File plugin : spec.getScalaCompilerPlugins()) {
                result2.add("-Xplugin:" + plugin.getPath());
            }
        }
        return result2;
    }

    private void addFlag(String name, boolean value, List<String> result2) {
        if (value) {
            result2.add(name);
        }
    }

    private void addOption(String name, Object value, List<String> result2) {
        if (value != null) {
            result2.add(name);
            result2.add(value.toString());
        }
    }

    private void addConcatenatedOption(String name, Object value, List<String> result2) {
        if (value != null) {
            result2.add(name + value.toString());
        }
    }
}

