/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.artifacts.transform.TransformationResult;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;

public class TransformationResultSerializer {
    private static final String INPUT_FILE_PATH_PREFIX = "i/";
    private static final String OUTPUT_FILE_PATH_PREFIX = "o/";
    private final File inputArtifact;
    private final File outputDir;

    public TransformationResultSerializer(File inputArtifact, File outputDir) {
        this.inputArtifact = inputArtifact;
        this.outputDir = outputDir;
    }

    public TransformationResult writeToFile(File target, ImmutableList<File> result2) {
        TransformationResult.Builder builder = TransformationResult.builder();
        String outputDirPrefix = this.outputDir.getPath() + File.separator;
        String inputFilePrefix = this.inputArtifact.getPath() + File.separator;
        ArrayList resultFileContents = new ArrayList(result2.size());
        result2.forEach(file -> {
            if (file.equals(this.outputDir)) {
                builder.addOutput(this.outputDir);
                resultFileContents.add(OUTPUT_FILE_PATH_PREFIX);
            } else if (file.equals(this.inputArtifact)) {
                builder.addInputArtifact();
                resultFileContents.add(INPUT_FILE_PATH_PREFIX);
            } else {
                String absolutePath = file.getAbsolutePath();
                if (absolutePath.startsWith(outputDirPrefix)) {
                    builder.addOutput((File)file);
                    resultFileContents.add(OUTPUT_FILE_PATH_PREFIX + RelativePath.parse(true, absolutePath.substring(outputDirPrefix.length())).getPathString());
                } else if (absolutePath.startsWith(inputFilePrefix)) {
                    String relativePath = RelativePath.parse(true, absolutePath.substring(inputFilePrefix.length())).getPathString();
                    builder.addInputArtifact(relativePath);
                    resultFileContents.add(INPUT_FILE_PATH_PREFIX + relativePath);
                } else {
                    throw new IllegalStateException("Invalid result path: " + absolutePath);
                }
            }
        });
        UncheckedException.unchecked(() -> Files.write(target.toPath(), (Iterable<? extends CharSequence>)resultFileContents, new OpenOption[0]));
        return builder.build();
    }

    public TransformationResult readResultsFile(File resultsFile) {
        Path transformerResultsPath = resultsFile.toPath();
        try {
            TransformationResult.Builder builder = TransformationResult.builder();
            List<String> paths = Files.readAllLines(transformerResultsPath, StandardCharsets.UTF_8);
            for (String path : paths) {
                if (path.startsWith(OUTPUT_FILE_PATH_PREFIX)) {
                    builder.addOutput(new File(this.outputDir, path.substring(2)));
                    continue;
                }
                if (path.startsWith(INPUT_FILE_PATH_PREFIX)) {
                    String relativePathString = path.substring(2);
                    if (relativePathString.isEmpty()) {
                        builder.addInputArtifact();
                        continue;
                    }
                    builder.addInputArtifact(relativePathString);
                    continue;
                }
                throw new IllegalStateException("Cannot parse result path string: " + path);
            }
            return builder.build();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

