/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.util.Set;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;

class TasksFromDependentProjects
extends AbstractTaskDependency {
    private final String taskName;
    private final String configurationName;
    private final TaskDependencyChecker checker;

    public TasksFromDependentProjects(String taskName, String configurationName) {
        this(taskName, configurationName, new TaskDependencyChecker());
    }

    public TasksFromDependentProjects(String taskName, String configurationName, TaskDependencyChecker checker) {
        this.taskName = taskName;
        this.configurationName = configurationName;
        this.checker = checker;
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        Project thisProject = context.getTask().getProject();
        Set<Task> tasksWithName = thisProject.getRootProject().getTasksByName(this.taskName, true);
        for (Task nextTask : tasksWithName) {
            boolean isDependency;
            if (context.getTask() == nextTask || !(isDependency = this.checker.isDependent(thisProject, this.configurationName, nextTask.getProject()))) continue;
            context.add(nextTask);
        }
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getConfigurationName() {
        return this.configurationName;
    }

    static class TaskDependencyChecker {
        TaskDependencyChecker() {
        }

        boolean isDependent(Project originProject, String configurationName, Project candidateProject) {
            Configuration configuration2 = (Configuration)candidateProject.getConfigurations().findByName(configurationName);
            return configuration2 != null && TaskDependencyChecker.doesConfigurationDependOnProject(configuration2, originProject);
        }

        private static boolean doesConfigurationDependOnProject(Configuration configuration2, Project project) {
            DomainObjectCollection projectDependencies = configuration2.getAllDependencies().withType(ProjectDependency.class);
            for (ProjectDependency projectDependency : projectDependencies) {
                if (!projectDependency.getDependencyProject().equals(project)) continue;
                return true;
            }
            return false;
        }
    }
}

