/*
 * Decompiled with CFR 0.152.
 */
package net.rubygrapefruit.platform.internal;

import net.rubygrapefruit.platform.NativeException;
import net.rubygrapefruit.platform.internal.AbstractWindowsTerminalInput;
import net.rubygrapefruit.platform.internal.CharInputBuffer;
import net.rubygrapefruit.platform.internal.FunctionResult;
import net.rubygrapefruit.platform.internal.jni.WindowsConsoleFunctions;
import net.rubygrapefruit.platform.terminal.TerminalInput;
import net.rubygrapefruit.platform.terminal.TerminalInputListener;

public class WindowsTerminalInput
extends AbstractWindowsTerminalInput {
    private boolean raw;

    public String toString() {
        return "Windows console on stdin";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(TerminalInputListener listener2) {
        Object object = this.lock;
        synchronized (object) {
            if (this.raw) {
                FunctionResult result2 = new FunctionResult();
                CharInputBuffer buffer = new CharInputBuffer();
                WindowsConsoleFunctions.readInput(buffer, result2);
                if (result2.isFailed()) {
                    throw new NativeException(String.format("Could not read from console: %s", result2.getMessage()));
                }
                buffer.applyTo(listener2);
            } else {
                this.readNonRaw(listener2);
            }
        }
    }

    public boolean supportsRawMode() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalInput rawMode() throws NativeException {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result2 = new FunctionResult();
            WindowsConsoleFunctions.rawInputMode(result2);
            if (result2.isFailed()) {
                throw new NativeException(String.format("Could not switch console input to raw mode: %s", result2.getMessage()));
            }
            this.raw = true;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalInput reset() {
        Object object = this.lock;
        synchronized (object) {
            FunctionResult result2 = new FunctionResult();
            WindowsConsoleFunctions.resetInputMode(result2);
            if (result2.isFailed()) {
                throw new NativeException(String.format("Could not reset console input mode: %s", result2.getMessage()));
            }
            this.raw = false;
        }
        return this;
    }
}

