/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.configuration;

import com.intellij.execution.JUnitBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.TestObject;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.BiConsumer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JUnitConfigurationModel {
    public static final int ALL_IN_PACKAGE = 0;
    public static final int CLASS = 1;
    public static final int METHOD = 2;
    public static final int PATTERN = 3;
    public static final int DIR = 4;
    public static final int CATEGORY = 5;
    public static final int UNIQUE_ID = 6;
    public static final int TAGS = 7;
    public static final int BY_SOURCE_POSITION = 8;
    public static final int BY_SOURCE_CHANGES = 9;
    private static final List<String> ourTestObjects = Arrays.asList("package", "class", "method", "pattern", "directory", "category", "uniqueId", "tags", "source location", "changes");
    private BiConsumer<Integer, Integer> myListener;
    private int myType = -1;
    private final Object[] myJUnitDocuments = new Object[6];
    private final Project myProject;

    public JUnitConfigurationModel(Project project) {
        this.myProject = project;
    }

    public boolean setType(int type) {
        if (type == this.myType) {
            return false;
        }
        int oldType = this.myType;
        if (type < 0 || type >= ourTestObjects.size()) {
            type = 1;
        }
        this.myType = type;
        this.fireTypeChanged(oldType, type);
        return true;
    }

    private void fireTypeChanged(int oldType, int newType) {
        this.myListener.accept(oldType, newType);
    }

    public void setListener(BiConsumer<Integer, Integer> listener) {
        this.myListener = listener;
    }

    public Object getJUnitDocument(int i) {
        return this.myJUnitDocuments[i];
    }

    public void setJUnitDocument(int i, Object doc) {
        this.myJUnitDocuments[i] = doc;
    }

    public void apply(Module module, JUnitConfiguration configuration) {
        boolean shouldUpdateName = configuration.isGeneratedName();
        this.applyTo(configuration.getPersistentData(), module);
        if (shouldUpdateName && !JavaExecutionUtil.isNewName((String)configuration.getName())) {
            configuration.setGeneratedName();
        }
    }

    private void applyTo(JUnitConfiguration.Data data, Module module) {
        block16: {
            String testObject = this.getTestObject();
            String className = this.getJUnitTextValue(1);
            data.TEST_OBJECT = testObject;
            if (testObject != "package" && testObject != "pattern" && testObject != "directory" && testObject != "category" && testObject != "changes") {
                data.METHOD_NAME = this.getJUnitTextValue(2);
                if (!className.equals(JUnitConfigurationModel.replaceRuntimeClassName(data.getMainClassName()))) {
                    try {
                        PsiClass testClass;
                        if (!this.myProject.isDefault() && !StringUtil.isEmptyOrSpaces((String)className)) {
                            JavaRunConfigurationModule configurationModule = new JavaRunConfigurationModule(this.myProject, true);
                            configurationModule.setModule(module);
                            testClass = configurationModule.findClass(className);
                        } else {
                            testClass = null;
                        }
                        if (testClass != null && testClass.isValid()) {
                            data.setMainClass(testClass);
                            break block16;
                        }
                        data.MAIN_CLASS_NAME = className;
                    }
                    catch (ProcessCanceledException | IndexNotReadyException e) {
                        data.MAIN_CLASS_NAME = className;
                    }
                }
            } else if (testObject != "changes") {
                if (testObject == "package") {
                    data.PACKAGE_NAME = this.getJUnitTextValue(0);
                } else if (testObject == "directory") {
                    data.setDirName(this.getJUnitTextValue(4));
                } else if (testObject == "category") {
                    data.setCategoryName(this.getJUnitTextValue(5));
                } else {
                    String[] patterns;
                    LinkedHashSet<String> set = new LinkedHashSet<String>();
                    for (String pattern : patterns = this.getJUnitTextValue(3).split("\\|\\|")) {
                        if (pattern.length() <= 0) continue;
                        set.add(pattern);
                    }
                    data.setPatterns(set);
                }
                data.MAIN_CLASS_NAME = "";
                data.METHOD_NAME = "";
            }
        }
    }

    private String getTestObject() {
        return ourTestObjects.get(this.myType);
    }

    private String getJUnitTextValue(int index) {
        return JUnitConfigurationModel.getDocumentText(index, this.myJUnitDocuments);
    }

    private static String getDocumentText(int index, Object[] documents) {
        Object document = documents[index];
        if (document instanceof PlainDocument) {
            try {
                return ((PlainDocument)document).getText(0, ((PlainDocument)document).getLength());
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
        return ((Document)document).getText();
    }

    public void reset(JUnitConfiguration configuration) {
        JUnitConfiguration.Data data = configuration.getPersistentData();
        this.setTestType(data.TEST_OBJECT);
        this.setJUnitTextValue(0, data.getPackageName());
        this.setJUnitTextValue(1, JUnitConfigurationModel.replaceRuntimeClassName(data.getMainClassName()));
        this.setJUnitTextValue(2, data.getMethodNameWithSignature());
        this.setJUnitTextValue(3, data.getPatternPresentation());
        this.setJUnitTextValue(4, data.getDirName());
        this.setJUnitTextValue(5, data.getCategory());
    }

    private static String replaceRuntimeClassName(String mainClassName) {
        return mainClassName.replaceAll("\\$", "\\.");
    }

    private void setJUnitTextValue(int index, String text) {
        this.setDocumentText(index, text, this.myJUnitDocuments);
    }

    private void setDocumentText(int index, String text, Object[] documents) {
        Object document = documents[index];
        if (document instanceof PlainDocument) {
            try {
                ((PlainDocument)document).remove(0, ((PlainDocument)document).getLength());
                ((PlainDocument)document).insertString(0, text, null);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        } else {
            WriteCommandAction.runWriteCommandAction((Project)this.myProject, () -> ((Document)document).replaceString(0, ((Document)document).getTextLength(), (CharSequence)text));
        }
    }

    private void setTestType(String testObject) {
        this.setType(ourTestObjects.indexOf(testObject));
    }

    @NotNull
    @NlsContexts.Label
    public static String getKindName(int value) {
        switch (value) {
            case 0: {
                return JUnitBundle.message("junit.configuration.kind.all.in.package", new Object[0]);
            }
            case 4: {
                return JUnitBundle.message("junit.configuration.kind.all.in.directory", new Object[0]);
            }
            case 3: {
                return JUnitBundle.message("junit.configuration.kind.by.pattern", new Object[0]);
            }
            case 1: {
                return JUnitBundle.message("junit.configuration.kind.class", new Object[0]);
            }
            case 2: {
                return JUnitBundle.message("junit.configuration.kind.method", new Object[0]);
            }
            case 5: {
                return JUnitBundle.message("junit.configuration.kind.category", new Object[0]);
            }
            case 6: {
                return JUnitBundle.message("junit.configuration.kind.by.unique.id", new Object[0]);
            }
            case 7: {
                return JUnitBundle.message("junit.configuration.kind.by.tags", new Object[0]);
            }
            case 8: {
                return "Through source location";
            }
            case 9: {
                return "Over changes in sources";
            }
        }
        throw new IllegalArgumentException(String.valueOf(value));
    }

    @NotNull
    @NlsContexts.Label
    public static String getRepeatModeName(@NotNull @NonNls String value) {
        switch (value) {
            case "Once": {
                return JUnitBundle.message("junit.configuration.repeat.mode.once", new Object[0]);
            }
            case "N Times": {
                return JUnitBundle.message("junit.configuration.repeat.mode.n.times", new Object[0]);
            }
            case "Until Failure": {
                return JUnitBundle.message("junit.configuration.repeat.mode.until.failure", new Object[0]);
            }
            case "Until Stopped": {
                return JUnitBundle.message("junit.configuration.repeat.mode.until.stopped", new Object[0]);
            }
        }
        throw new IllegalArgumentException(value);
    }

    @NotNull
    @NlsContexts.Label
    public static String getForkModeName(@NotNull @NonNls String value) {
        switch (value) {
            case "none": {
                return JUnitBundle.message("junit.configuration.fork.mode.none", new Object[0]);
            }
            case "method": {
                return JUnitBundle.message("junit.configuration.fork.mode.method", new Object[0]);
            }
            case "class": {
                return JUnitBundle.message("junit.configuration.fork.mode.class", new Object[0]);
            }
            case "repeat": {
                return JUnitBundle.message("junit.configuration.fork.mode.repeat", new Object[0]);
            }
        }
        throw new IllegalArgumentException(value);
    }

    public void reloadTestKindModel(JComboBox<Integer> comboBox, Module module) {
        GlobalSearchScope searchScope;
        int selectedIndex = comboBox.getSelectedIndex();
        DefaultComboBoxModel<Integer> aModel = new DefaultComboBoxModel<Integer>();
        aModel.addElement(0);
        aModel.addElement(4);
        aModel.addElement(3);
        aModel.addElement(1);
        aModel.addElement(2);
        GlobalSearchScope globalSearchScope = searchScope = module != null ? GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)true) : GlobalSearchScope.allScope((Project)this.myProject);
        if (this.myProject.isDefault() || JavaPsiFacade.getInstance((Project)this.myProject).findPackage("org.junit") != null) {
            aModel.addElement(5);
        }
        if (this.myProject.isDefault() || JUnitUtil.isJUnit5((GlobalSearchScope)searchScope, (Project)this.myProject) || TestObject.hasJUnit5EnginesAPI(searchScope, JavaPsiFacade.getInstance((Project)this.myProject))) {
            aModel.addElement(6);
            aModel.addElement(7);
        }
        if (Registry.is((String)"testDiscovery.enabled")) {
            aModel.addElement(8);
            aModel.addElement(9);
        }
        comboBox.setModel(aModel);
        comboBox.setSelectedIndex(selectedIndex);
    }

    public boolean disableModuleClasspath(boolean wholeProjectSelected) {
        return wholeProjectSelected && (this.myType == 0 || this.myType == 3 || this.myType == 5 || this.myType == 7 || this.myType == 6);
    }
}

