/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit.testDiscovery;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.TestObject;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.local.LocalTargetEnvironment;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.testDiscovery.TestDiscoverySearchHelper;
import com.intellij.execution.testframework.SearchForTestsTask;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.util.FunctionUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class JUnitTestDiscoveryRunnableState
extends TestObject {
    JUnitTestDiscoveryRunnableState(JUnitConfiguration configuration, ExecutionEnvironment environment) {
        super(configuration, environment);
    }

    protected abstract String getChangeList();

    protected abstract Pair<String, String> getPosition();

    @Override
    protected TestSearchScope getScope() {
        return ((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule() != null ? TestSearchScope.MODULE_WITH_DEPENDENCIES : TestSearchScope.WHOLE_PROJECT;
    }

    protected boolean forkPerModule() {
        return ((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule() == null;
    }

    @Override
    protected PsiElement retrievePsiElement(Object pattern) {
        String className;
        if (pattern instanceof String && !pattern.equals(className = StringUtil.getPackageName((String)((String)pattern), (char)','))) {
            Project project = this.getConfiguration().getProject();
            PsiManager manager = PsiManager.getInstance((Project)project);
            SourceScope sourceScope = this.getSourceScope();
            GlobalSearchScope globalSearchScope = sourceScope != null ? sourceScope.getGlobalSearchScope() : GlobalSearchScope.projectScope((Project)project);
            return ClassUtil.findPsiClass((PsiManager)manager, (String)className, null, (boolean)true, (GlobalSearchScope)globalSearchScope);
        }
        return null;
    }

    @Nullable
    public SearchForTestsTask createSearchingForTestsTask() {
        return this.createSearchingForTestsTask((TargetEnvironment)new LocalTargetEnvironment(new LocalTargetEnvironmentRequest()));
    }

    @Nullable
    public SearchForTestsTask createSearchingForTestsTask(@NotNull TargetEnvironment targetEnvironment) {
        return new SearchForTestsTask(this.getConfiguration().getProject(), this.getServerSocket()){
            private Set<String> myPatterns;

            protected void search() {
                this.myPatterns = TestDiscoverySearchHelper.search((Project)this.getProject(), JUnitTestDiscoveryRunnableState.this.getPosition(), (String)JUnitTestDiscoveryRunnableState.this.getChangeList(), (byte)JUnitTestDiscoveryRunnableState.this.getConfiguration().getTestFrameworkId());
            }

            protected void onFound() {
                if (this.myPatterns != null) {
                    try {
                        JUnitTestDiscoveryRunnableState.this.addClassesListToJavaParameters(this.myPatterns, FunctionUtil.id(), "", false, JUnitTestDiscoveryRunnableState.this.getJavaParameters());
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    @Override
    protected JavaParameters createJavaParameters() throws ExecutionException {
        JavaParameters javaParameters = super.createJavaParameters();
        this.createTempFiles(javaParameters);
        this.createServerSocket(javaParameters);
        return javaParameters;
    }

    @Override
    public String suggestActionName() {
        return "";
    }

    @Override
    public RefactoringElementListener getListener(PsiElement element) {
        return null;
    }

    @Override
    public boolean isConfiguredByElement(JUnitConfiguration configuration, PsiClass testClass, PsiMethod testMethod, PsiPackage testPackage, PsiDirectory testDir) {
        return false;
    }
}

