/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationProducer;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.UniqueIdConfigurationProducer;
import com.intellij.execution.testframework.AbstractInClassConfigurationProducer;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import org.jetbrains.annotations.NotNull;

public final class TestInClassConfigurationProducer
extends JUnitConfigurationProducer {
    private final JUnitInClassConfigurationProducerDelegate myDelegate = new JUnitInClassConfigurationProducerDelegate();

    protected boolean setupConfigurationFromContext(@NotNull JUnitConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        return this.myDelegate.setupConfigurationFromContext(configuration, context, sourceElement);
    }

    public void onFirstRun(@NotNull ConfigurationFromContext configuration, @NotNull ConfigurationContext fromContext, @NotNull Runnable performRunnable) {
        this.myDelegate.onFirstRun(configuration, fromContext, performRunnable);
    }

    public boolean isConfigurationFromContext(@NotNull JUnitConfiguration configuration, @NotNull ConfigurationContext context) {
        String[] nodeIds = UniqueIdConfigurationProducer.getNodeIds(context);
        if (nodeIds != null && nodeIds.length > 0) {
            return false;
        }
        return super.isConfigurationFromContext((JavaTestConfigurationBase)configuration, context);
    }

    protected boolean isApplicableTestType(String type, ConfigurationContext context) {
        return this.myDelegate.isApplicableTestType(type, context);
    }

    private static class JUnitInClassConfigurationProducerDelegate
    extends AbstractInClassConfigurationProducer<JUnitConfiguration> {
        private JUnitInClassConfigurationProducerDelegate() {
        }

        @NotNull
        public ConfigurationFactory getConfigurationFactory() {
            return JUnitConfigurationType.getInstance().getConfigurationFactories()[0];
        }

        protected boolean isApplicableTestType(String type, ConfigurationContext context) {
            return "class".equals(type) || "method".equals(type);
        }

        protected boolean isRequiredVisibility(PsiMember psiElement) {
            if (JUnitUtil.isJUnit5((PsiElement)psiElement)) {
                return true;
            }
            return super.isRequiredVisibility(psiElement);
        }

        protected boolean setupConfigurationFromContext(@NotNull JUnitConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
            return super.setupConfigurationFromContext((JavaTestConfigurationBase)configuration, context, sourceElement);
        }
    }
}

