/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardCustomizer;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitRunDashboardCustomizer
extends RunDashboardCustomizer {
    public boolean isApplicable(@NotNull RunnerAndConfigurationSettings settings, @Nullable RunContentDescriptor descriptor) {
        return settings.getConfiguration() instanceof JUnitConfiguration;
    }

    @Nullable
    public PsiElement getPsiElement(@NotNull RunDashboardRunConfigurationNode node) {
        PsiMethod[] methods;
        RunConfiguration runConfiguration = node.getConfigurationSettings().getConfiguration();
        if (!(runConfiguration instanceof JUnitConfiguration)) {
            return null;
        }
        JUnitConfiguration jUnitConfiguration = (JUnitConfiguration)runConfiguration;
        String runClassName = jUnitConfiguration.getRunClass();
        if (runClassName == null) {
            return null;
        }
        PsiClass runClass = ((JavaRunConfigurationModule)jUnitConfiguration.getConfigurationModule()).findClass(runClassName);
        if (runClass == null) {
            return null;
        }
        String testMethod = jUnitConfiguration.getPersistentData().getMethodName();
        if (testMethod != null && (methods = runClass.findMethodsByName(testMethod, false)).length > 0) {
            return methods[0];
        }
        return runClass;
    }
}

