/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.ShortenCommandLine;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.JUnitRunConfigurationImporter$WhenMappings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.settings.RunConfigurationImporter;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J2\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0010\u0010\u000f\u001a\f\u0012\u0004\u0012\u00020\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/execution/junit/JUnitRunConfigurationImporter;", "Lcom/intellij/openapi/externalSystem/service/project/settings/RunConfigurationImporter;", "()V", "canImport", "", "typeName", "", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "process", "", "project", "Lcom/intellij/openapi/project/Project;", "runConfig", "Lcom/intellij/execution/configurations/RunConfiguration;", "cfg", "", "modelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "Companion", "TestKind", "intellij.junit"})
public final class JUnitRunConfigurationImporter
implements RunConfigurationImporter {
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    public boolean canImport(@NotNull String typeName) {
        return Intrinsics.areEqual((Object)"junit", (Object)typeName);
    }

    /*
     * WARNING - void declaration
     */
    public void process(@NotNull Project project, @NotNull RunConfiguration runConfig, @NotNull Map<String, ?> cfg, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Object object;
        Object v0;
        JUnitConfiguration.Data data;
        block10: {
            if (!(runConfig instanceof JUnitConfiguration)) {
                throw (Throwable)new IllegalArgumentException("Unexpected type of run configuration: " + runConfig.getClass());
            }
            data = ((JUnitConfiguration)runConfig).getPersistentData();
            Iterable $this$firstOrNull$iv = cfg.keySet();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                void $this$mapTo$iv$iv;
                String it = (String)element$iv;
                boolean bl = false;
                TestKind[] $this$map$iv = TestKind.values();
                boolean $i$f$map = false;
                TestKind[] testKindArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void testKind;
                    void item$iv$iv;
                    void var21_22 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    String string = testKind.getDslName();
                    collection.add(string);
                }
                if (!(((List)destination$iv$iv).contains(it) && cfg.get(it) != null)) continue;
                v0 = element$iv;
                break block10;
            }
            v0 = null;
        }
        String testKindName = v0;
        if (testKindName != null) {
            ObjectUtils.consumeIfCast(cfg.get(testKindName), String.class, (Consumer)new Consumer(data, testKindName){
                final /* synthetic */ JUnitConfiguration.Data $data;
                final /* synthetic */ String $testKindName;

                /*
                 * Unable to fully structure code
                 */
                public final void consume(String testKindValue) {
                    v0 = this.$data;
                    v1 = TestKind.Companion.byDslName(this.$testKindName);
                    if (v1 == null) ** GOTO lbl63
                    switch (JUnitRunConfigurationImporter$WhenMappings.$EnumSwitchMapping$0[v1.ordinal()]) {
                        case 1: {
                            var3_8 = var2_2 = "package";
                            var7_14 = v0;
                            $i$a$-also-JUnitRunConfigurationImporter$process$1$1 = false;
                            this.$data.PACKAGE_NAME = testKindValue;
                            var8_26 = Unit.INSTANCE;
                            v0 = var7_14;
                            v2 = var2_2;
                            break;
                        }
                        case 2: {
                            it = var2_3 = "directory";
                            var7_15 = v0;
                            $i$a$-also-JUnitRunConfigurationImporter$process$1$2 = false;
                            this.$data.setDirName(testKindValue);
                            var8_27 = Unit.INSTANCE;
                            v0 = var7_15;
                            v2 = var2_3;
                            break;
                        }
                        case 3: {
                            it = var2_4 = "pattern";
                            var7_16 = v0;
                            $i$a$-also-JUnitRunConfigurationImporter$process$1$3 = false;
                            this.$data.setPatterns(new LinkedHashSet<String>(StringsKt.split$default((CharSequence)testKindValue, (char[])new char[]{','}, (boolean)false, (int)0, (int)6, null)));
                            var8_28 = Unit.INSTANCE;
                            v0 = var7_16;
                            v2 = var2_4;
                            break;
                        }
                        case 4: {
                            it = var2_5 = "class";
                            var7_17 = v0;
                            $i$a$-also-JUnitRunConfigurationImporter$process$1$4 = false;
                            this.$data.MAIN_CLASS_NAME = testKindValue;
                            var8_29 = Unit.INSTANCE;
                            v0 = var7_17;
                            v2 = var2_5;
                            break;
                        }
                        case 5: {
                            it = var2_6 = "method";
                            var7_18 = v0;
                            $i$a$-also-JUnitRunConfigurationImporter$process$1$5 = false;
                            className = StringsKt.substringBefore$default((String)testKindValue, (char)'#', null, (int)2, null);
                            methodName = StringsKt.substringAfter$default((String)testKindValue, (char)'#', null, (int)2, null);
                            this.$data.MAIN_CLASS_NAME = className;
                            this.$data.METHOD_NAME = methodName;
                            var8_30 = Unit.INSTANCE;
                            v0 = var7_18;
                            v2 = var2_6;
                            break;
                        }
                        case 6: {
                            it = var2_7 = "category";
                            var7_19 = v0;
                            $i$a$-also-JUnitRunConfigurationImporter$process$1$6 = false;
                            this.$data.setCategoryName(testKindValue);
                            var8_31 = Unit.INSTANCE;
                            v0 = var7_19;
                            v2 = var2_7;
                            break;
                        }
lbl63:
                        // 1 sources

                        v2 = this.$data.TEST_OBJECT;
                        break;
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    v0.TEST_OBJECT = v2;
                }
                {
                    this.$data = data;
                    this.$testKindName = string;
                }
            });
        }
        Object repeatValue = cfg.get("repeat");
        JUnitConfiguration jUnitConfiguration = (JUnitConfiguration)runConfig;
        Object obj = repeatValue;
        if (Intrinsics.areEqual(obj, (Object)"untilStop")) {
            object = "Until Stopped";
        } else if (Intrinsics.areEqual(obj, (Object)"untilFailure")) {
            object = "Until Failure";
        } else if (obj instanceof Number) {
            Object element$iv;
            String string = "N Times";
            element$iv = string;
            JUnitConfiguration jUnitConfiguration2 = jUnitConfiguration;
            boolean bl = false;
            ((JUnitConfiguration)runConfig).setRepeatCount(((Number)repeatValue).intValue());
            Unit unit = Unit.INSTANCE;
            jUnitConfiguration = jUnitConfiguration2;
            object = string;
        } else {
            object = ((JUnitConfiguration)runConfig).getRepeatMode();
        }
        jUnitConfiguration.setRepeatMode((String)object);
        ObjectUtils.consumeIfCast(cfg.get("vmParameters"), String.class, (Consumer)new Consumer(runConfig){
            final /* synthetic */ RunConfiguration $runConfig;

            public final void consume(String it) {
                ((JUnitConfiguration)this.$runConfig).setVMParameters(it);
            }
            {
                this.$runConfig = runConfiguration;
            }
        });
        ObjectUtils.consumeIfCast(cfg.get("workingDirectory"), String.class, (Consumer)new Consumer(runConfig){
            final /* synthetic */ RunConfiguration $runConfig;

            public final void consume(String it) {
                ((JUnitConfiguration)this.$runConfig).setWorkingDirectory(it);
            }
            {
                this.$runConfig = runConfiguration;
            }
        });
        ObjectUtils.consumeIfCast(cfg.get("passParentEnvs"), Boolean.TYPE, (Consumer)new Consumer(runConfig){
            final /* synthetic */ RunConfiguration $runConfig;

            public final void consume(Boolean it) {
                ((JUnitConfiguration)this.$runConfig).setPassParentEnvs(it);
            }
            {
                this.$runConfig = runConfiguration;
            }
        });
        ObjectUtils.consumeIfCast(cfg.get("envs"), Map.class, (Consumer)new Consumer(runConfig){
            final /* synthetic */ RunConfiguration $runConfig;

            public final void consume(Map<?, ?> it) {
                Map<String, String> map = it;
                if (map == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
                }
                ((JUnitConfiguration)this.$runConfig).setEnvs(map);
            }
            {
                this.$runConfig = runConfiguration;
            }
        });
        ObjectUtils.consumeIfCast(cfg.get("moduleName"), String.class, (Consumer)new Consumer(modelsProvider, runConfig){
            final /* synthetic */ IdeModifiableModelsProvider $modelsProvider;
            final /* synthetic */ RunConfiguration $runConfig;

            public final void consume(String it) {
                Module module = this.$modelsProvider.getModifiableModuleModel().findModuleByName(it);
                if (module != null) {
                    ((JUnitConfiguration)this.$runConfig).setModule(module);
                }
            }
            {
                this.$modelsProvider = ideModifiableModelsProvider;
                this.$runConfig = runConfiguration;
            }
        });
        ObjectUtils.consumeIfCast(cfg.get("shortenCommandLine"), String.class, (Consumer)new Consumer(runConfig){
            final /* synthetic */ RunConfiguration $runConfig;

            public final void consume(String it) {
                try {
                    ((JUnitConfiguration)this.$runConfig).setShortenCommandLine(ShortenCommandLine.valueOf((String)it));
                }
                catch (IllegalArgumentException e) {
                    JUnitRunConfigurationImporter.Companion.getLOG().warn("Illegal value of 'shortenCommandLine': " + it, (Throwable)e);
                }
            }
            {
                this.$runConfig = runConfiguration;
            }
        });
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return ((JUnitConfigurationType)ConfigurationTypeUtil.findConfigurationType(JUnitConfigurationType.class)).getConfigurationFactories()[0];
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(JUnitRunConfigurationImporter.class);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0082\u0001\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\rB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\u000e"}, d2={"Lcom/intellij/execution/junit/JUnitRunConfigurationImporter$TestKind;", "", "dslName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getDslName", "()Ljava/lang/String;", "PACKAGE_NAME", "DIRECTORY", "PATTERN", "CLASS", "METHOD", "CATEGORY", "Companion", "intellij.junit"})
    private static final class TestKind
    extends Enum<TestKind> {
        public static final /* enum */ TestKind PACKAGE_NAME;
        public static final /* enum */ TestKind DIRECTORY;
        public static final /* enum */ TestKind PATTERN;
        public static final /* enum */ TestKind CLASS;
        public static final /* enum */ TestKind METHOD;
        public static final /* enum */ TestKind CATEGORY;
        private static final /* synthetic */ TestKind[] $VALUES;
        @NotNull
        private final String dslName;
        @NotNull
        public static final Companion Companion;

        static {
            TestKind[] testKindArray = new TestKind[6];
            TestKind[] testKindArray2 = testKindArray;
            testKindArray[0] = PACKAGE_NAME = new TestKind("packageName");
            testKindArray[1] = DIRECTORY = new TestKind("directory");
            testKindArray[2] = PATTERN = new TestKind("pattern");
            testKindArray[3] = CLASS = new TestKind("class");
            testKindArray[4] = METHOD = new TestKind("method");
            testKindArray[5] = CATEGORY = new TestKind("category");
            $VALUES = testKindArray;
            Companion = new Companion(null);
        }

        @NotNull
        public final String getDslName() {
            return this.dslName;
        }

        private TestKind(String dslName) {
            this.dslName = dslName;
        }

        public static TestKind[] values() {
            return (TestKind[])$VALUES.clone();
        }

        public static TestKind valueOf(String string) {
            return Enum.valueOf(TestKind.class, string);
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/execution/junit/JUnitRunConfigurationImporter$TestKind$Companion;", "", "()V", "byDslName", "Lcom/intellij/execution/junit/JUnitRunConfigurationImporter$TestKind;", "dslName", "", "intellij.junit"})
        public static final class Companion {
            @Nullable
            public final TestKind byDslName(@NotNull String dslName) {
                TestKind testKind;
                block1: {
                    TestKind[] testKindArray;
                    TestKind[] testKindArray2 = testKindArray = TestKind.values();
                    int n = testKindArray2.length;
                    for (int i = 0; i < n; ++i) {
                        TestKind testKind2;
                        TestKind it = testKind2 = testKindArray2[i];
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getDslName(), (Object)dslName)) continue;
                        testKind = testKind2;
                        break block1;
                    }
                    testKind = null;
                }
                return testKind;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/execution/junit/JUnitRunConfigurationImporter$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.junit"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

