/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.SLRUMap;
import com.intellij.util.containers.hash.EqualityPolicy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SLRUCache<K, V>
extends SLRUMap<K, V> {
    protected SLRUCache(int protectedQueueSize, int probationalQueueSize) {
        super(protectedQueueSize, probationalQueueSize);
    }

    protected SLRUCache(int protectedQueueSize, int probationalQueueSize, @NotNull EqualityPolicy<? super K> hashingStrategy) {
        super(protectedQueueSize, probationalQueueSize, hashingStrategy);
    }

    @NotNull
    public abstract V createValue(K var1);

    @Override
    @NotNull
    public V get(K key) {
        Object value = super.get(key);
        if (value != null) {
            return value;
        }
        value = this.createValue(key);
        this.put(key, value);
        return value;
    }

    @Nullable
    public V getIfCached(K key) {
        return super.get(key);
    }

    @NotNull
    public static <K, V> SLRUCache<K, V> create(int protectedQueueSize, int probationalQueueSize, final @NotNull NotNullFunction<? super K, ? extends V> valueProducer) {
        return new SLRUCache<K, V>(protectedQueueSize, probationalQueueSize){

            @Override
            @NotNull
            public V createValue(K key) {
                return valueProducer.fun(key);
            }
        };
    }
}

