/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.LoggerRt;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReflectionUtilRt {
    @NotNull
    public static List<Field> collectFields(@NotNull Class<?> clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        ReflectionUtilRt.collectFields(clazz, result);
        return result;
    }

    private static void collectFields(Class<?> clazz, List<? super Field> result) {
        result.addAll(Arrays.asList(clazz.getDeclaredFields()));
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            ReflectionUtilRt.collectFields(superClass, result);
        }
        for (Class<?> each : clazz.getInterfaces()) {
            ReflectionUtilRt.collectFields(each, result);
        }
    }

    public static <T> T getField(@NotNull Class<?> objectClass, @Nullable Object object, @Nullable(value="null means any type") Class<T> fieldType, @NotNull String fieldName) {
        Field field = ReflectionUtilRt.findField(objectClass, fieldName, fieldType);
        if (field != null) {
            try {
                Object t = field.get(object);
                return (T)t;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    private static Field findField(Class<?> clazz, String fieldName, @Nullable Class<?> fieldType) {
        Field result;
        for (Field field : clazz.getDeclaredFields()) {
            if (!fieldName.equals(field.getName()) || fieldType != null && !fieldType.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            return field;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && (result = ReflectionUtilRt.findField(superClass, fieldName, fieldType)) != null) {
            return result;
        }
        for (Class<?> each : clazz.getInterfaces()) {
            Field result2 = ReflectionUtilRt.findField(each, fieldName, fieldType);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    @Nullable
    public static Class<?> findCallerClass(int framesToSkip) {
        try {
            Class<?>[] stack = MySecurityManager.INSTANCE.getStack();
            int indexFromTop = 1 + framesToSkip;
            return stack.length > indexFromTop ? stack[indexFromTop] : null;
        }
        catch (Exception e) {
            LoggerRt.getInstance(ReflectionUtilRt.class).warn(e);
            return null;
        }
    }

    private static final class MySecurityManager
    extends SecurityManager {
        private static final MySecurityManager INSTANCE = new MySecurityManager();

        private MySecurityManager() {
        }

        Class<?>[] getStack() {
            return this.getClassContext();
        }
    }
}

