/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class Functions {
    private static final Function.Mono<?> ID = new Function.Mono<Object>(){

        @Override
        public Object fun(Object o) {
            return o;
        }

        public String toString() {
            return "Functions.ID";
        }
    };
    private static final Function<?, String> TO_STRING = new Function<Object, String>(){

        @Override
        public String fun(Object o) {
            return String.valueOf(o);
        }

        public String toString() {
            return "Functions.TO_STRING";
        }
    };
    private static final Function<Pair<?, ?>, Object> PAIR_FIRST = new Function<Pair<?, ?>, Object>(){

        @Override
        public Object fun(Pair<?, ?> pair) {
            return Pair.getFirst(pair);
        }
    };
    private static final Function<Pair<?, ?>, Object> PAIR_SECOND = new Function<Pair<?, ?>, Object>(){

        @Override
        public Object fun(Pair<?, ?> pair) {
            return Pair.getSecond(pair);
        }
    };
    private static final Function<Object[], Iterable<Object>> WRAP_ARRAY = new Function<Object[], Iterable<Object>>(){

        @Override
        public Iterable<Object> fun(Object[] t) {
            return t == null ? Collections.emptyList() : Arrays.asList(t);
        }
    };

    @NotNull
    public static <A> Function.Mono<A> id() {
        return (Function.Mono)Functions.identity();
    }

    @NotNull
    public static <A, B> Function<A, B> constant(final B b) {
        return new Function<A, B>(){

            @Override
            public B fun(A a) {
                return b;
            }
        };
    }

    @NotNull
    public static <A, B> Function<A, B> identity() {
        return ID;
    }

    @NotNull
    public static <A, B> Function<A, B> cast(@NotNull Class<B> clazz) {
        return Functions.identity();
    }

    @NotNull
    public static <A, B, C> Function<A, C> compose(final @NotNull Function<? super A, ? extends B> f1, final @NotNull Function<? super B, ? extends C> f2) {
        if (f1 == Functions.identity() || f2 == Functions.identity()) {
            if (f1 == f2) {
                return Functions.identity();
            }
            if (f1 == Functions.identity()) {
                return f2;
            }
            return f1;
        }
        return new Function<A, C>(){

            @Override
            public C fun(A a) {
                return f2.fun(f1.fun(a));
            }
        };
    }

    @NotNull
    public static <A> Function<A, String> TO_STRING() {
        return TO_STRING;
    }

    @NotNull
    public static <A, B> Function<A, B> fromMap(final @NotNull Map<? super A, ? extends B> map) {
        return new Function<A, B>(){

            @Override
            public B fun(A a) {
                return map.get(a);
            }
        };
    }

    @NotNull
    public static <A> Function<Pair<A, ?>, A> pairFirst() {
        return PAIR_FIRST;
    }

    @NotNull
    public static <B> Function<Pair<?, B>, B> pairSecond() {
        return PAIR_SECOND;
    }

    @NotNull
    public static <T> Function<T[], Iterable<T>> wrapArray() {
        return WRAP_ARRAY;
    }
}

